/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.effect.aoe;

import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.VFXAlphaFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffect;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffectProperties;
import hellfirepvp.astralsorcery.common.constellation.effect.base.CEffectAbstractList;
import hellfirepvp.astralsorcery.common.constellation.effect.base.ListEntries;
import hellfirepvp.astralsorcery.common.crafting.nojson.WorldFreezingRegistry;
import hellfirepvp.astralsorcery.common.crafting.nojson.WorldMeltableRegistry;
import hellfirepvp.astralsorcery.common.crafting.nojson.freezing.WorldFreezingRecipe;
import hellfirepvp.astralsorcery.common.crafting.nojson.meltable.WorldMeltableRecipe;
import hellfirepvp.astralsorcery.common.lib.ColorsAS;
import hellfirepvp.astralsorcery.common.lib.ConstellationsAS;
import hellfirepvp.astralsorcery.common.tile.TileRitualPedestal;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.block.ILocatable;
import hellfirepvp.astralsorcery.common.util.block.iterator.BlockPositionGenerator;
import hellfirepvp.astralsorcery.common.util.block.iterator.BlockRandomPositionGenerator;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.item.ItemUtils;
import java.awt.Color;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;

public class CEffectFornax
extends CEffectAbstractList<ListEntries.PosEntry> {
    public static FornaxConfig CONFIG = new FornaxConfig();

    public CEffectFornax(@Nonnull ILocatable origin) {
        super(origin, ConstellationsAS.fornax, 1, (world, pos, state) -> true);
        this.excludeRitualPositions();
        this.selectSphericalPositions();
    }

    @Override
    @Nonnull
    protected BlockPositionGenerator createPositionStrategy() {
        BlockRandomPositionGenerator gen = new BlockRandomPositionGenerator();
        gen.andFilter(pos -> pos.func_177956_o() < 0);
        return gen;
    }

    @Override
    @Nullable
    public ListEntries.PosEntry recreateElement(CompoundNBT tag, BlockPos pos) {
        return new ListEntries.PosEntry(pos);
    }

    @Override
    @Nullable
    public ListEntries.PosEntry createElement(World world, BlockPos pos) {
        return new ListEntries.PosEntry(pos);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void playClientEffect(World world, BlockPos pos, TileRitualPedestal pedestal, float alphaMultiplier, boolean extended) {
        Vector3 motion = Vector3.random().multiply(0.04);
        if (pos.equals((Object)pedestal.func_174877_v())) {
            motion.setY(0);
        } else {
            motion.setY(Math.abs(motion.getY()) * -1.0);
        }
        Color c = (Color)MiscUtils.eitherOf(rand, () -> ColorsAS.CONSTELLATION_FORNAX.brighter(), () -> ColorsAS.CONSTELLATION_FORNAX.darker(), () -> ColorsAS.CONSTELLATION_FORNAX.darker(), () -> ColorsAS.CONSTELLATION_FORNAX.darker().darker());
        ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(new Vector3((Vec3i)pos).add(0.5, 0.2, 0.5))).alpha(VFXAlphaFunction.FADE_OUT)).color(VFXColorFunction.constant(c))).setScaleMultiplier(0.3f + rand.nextFloat() * 0.4f)).setMotion(motion)).setGravityStrength(-0.0015f)).setMaxAge(60 + rand.nextInt(30));
    }

    @Override
    public boolean playEffect(World world, BlockPos pos, ConstellationEffectProperties properties, @Nullable IMinorConstellation trait) {
        if (!(world instanceof ServerWorld)) {
            return false;
        }
        Consumer<ItemStack> dropResult = stack -> ItemUtils.dropItemNaturally(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.2, (double)pos.func_177952_p() + 0.5, stack);
        return this.peekNewPosition(world, pos, properties).mapLeft(newEntry -> {
            BlockPos at = newEntry.getPos();
            if (properties.isCorrupted()) {
                WorldFreezingRecipe freezingRecipe = WorldFreezingRegistry.INSTANCE.getRecipeFor(world, at);
                if (freezingRecipe != null) {
                    freezingRecipe.doOutput(world, at, world.func_180495_p(at), dropResult);
                    return true;
                }
                return false;
            }
            WorldMeltableRecipe meltRecipe = WorldMeltableRegistry.INSTANCE.getRecipeFor(world, at);
            if (meltRecipe != null) {
                meltRecipe.doOutput(world, at, world.func_180495_p(at), dropResult);
                return true;
            }
            return false;
        }).ifRight(attemptedBreak -> this.sendConstellationPing((IWorld)world, new Vector3((Vec3i)attemptedBreak).add(0.5, 0.5, 0.5))).left().orElse(false);
    }

    @Override
    public ConstellationEffect.Config getConfig() {
        return CONFIG;
    }

    private static class FornaxConfig
    extends ConstellationEffect.Config {
        private final float defaultMeltFailChance = 0.0f;
        public ForgeConfigSpec.DoubleValue meltFailChance;

        public FornaxConfig() {
            super("fornax", 8.0, 2.0);
        }

        @Override
        public void createEntries(ForgeConfigSpec.Builder cfgBuilder) {
            super.createEntries(cfgBuilder);
            ForgeConfigSpec.Builder builder = cfgBuilder.comment("Defines the chance (0% to 100% -> 0.0 to 1.0) if the block will be replaced with air instead of being properly melted into something.").translation(this.translationKey("meltFailChance"));
            this.getClass();
            this.meltFailChance = builder.defineInRange("meltFailChance", 0.0, 0.0, 1.0);
        }
    }
}

