/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.mantle;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.VFXAlphaFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.data.config.base.ConfigEntry;
import hellfirepvp.astralsorcery.common.item.armor.ItemMantle;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import hellfirepvp.observerlib.common.util.tick.ITickHandler;
import hellfirepvp.observerlib.common.util.tick.TickManager;
import java.awt.Color;
import java.util.EnumSet;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class MantleEffect
extends ForgeRegistryEntry<MantleEffect>
implements ITickHandler {
    protected static final Random rand = new Random();
    private final IWeakConstellation constellation;

    public MantleEffect(IWeakConstellation constellation) {
        this.constellation = constellation;
        this.setRegistryName(this.constellation.getRegistryName());
        this.attachEventListeners(MinecraftForge.EVENT_BUS);
        this.attachTickHandlers(arg_0 -> ((TickManager)AstralSorcery.getProxy().getTickManager()).register(arg_0));
    }

    public final IWeakConstellation getAssociatedConstellation() {
        return this.constellation;
    }

    public abstract Config getConfig();

    protected void attachEventListeners(IEventBus bus) {
    }

    protected void attachTickHandlers(Consumer<ITickHandler> registrar) {
        if (this.usesTickMethods()) {
            registrar.accept(this);
        }
    }

    protected void tickServer(PlayerEntity player) {
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void tickClient(PlayerEntity player) {
    }

    protected boolean usesTickMethods() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void playCapeSparkles(PlayerEntity player, float chance) {
        Color c;
        if (player == Minecraft.func_71410_x().field_71439_g && Minecraft.func_71410_x().field_71474_y.field_74320_O == 0) {
            chance *= 0.1f;
        }
        if (rand.nextFloat() < chance && (c = this.getAssociatedConstellation().getConstellationColor()) != null) {
            float width = player.func_213311_cf() * 0.8f;
            double x = player.func_226277_ct_() + (double)(rand.nextFloat() * width * (float)(rand.nextBoolean() ? 1 : -1));
            double y = player.func_226278_cu_() + (double)(rand.nextFloat() * (player.func_213302_cg() / 3.0f));
            double z = player.func_226281_cx_() + (double)(rand.nextFloat() * width * (float)(rand.nextBoolean() ? 1 : -1));
            Vector3 pos = new Vector3(x, y, z);
            FXFacingParticle fx = (FXFacingParticle)((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)this.spawnFacingParticle(player, pos).color(VFXColorFunction.constant(c))).alpha(VFXAlphaFunction.FADE_OUT)).setScaleMultiplier(0.4f + rand.nextFloat() * 0.4f)).setMaxAge(20 + rand.nextInt(10));
            if (rand.nextInt(3) == 0) {
                fx.color(VFXColorFunction.constant(this.getAssociatedConstellation().getTierRenderColor()));
            }
            if (rand.nextFloat() > 0.35f) {
                ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)this.spawnFacingParticle(player, pos).color(VFXColorFunction.WHITE)).alpha(VFXAlphaFunction.FADE_OUT)).setScaleMultiplier(0.2f + rand.nextFloat() * 0.2f)).setMaxAge(10 + rand.nextInt(10));
            }
        }
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    protected FXFacingParticle spawnFacingParticle(PlayerEntity player, Vector3 at) {
        return (FXFacingParticle)((EffectHelper.Builder)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).setOwner(player.func_110124_au())).spawn(at);
    }

    public final void tick(TickEvent.Type type, Object ... context) {
        boolean hasMantle;
        if (!((Boolean)this.getConfig().enabled.get()).booleanValue()) {
            return;
        }
        PlayerEntity pl = (PlayerEntity)context[0];
        LogicalSide side = (LogicalSide)context[1];
        boolean bl = hasMantle = ItemMantle.getEffect((LivingEntity)pl, this.getAssociatedConstellation()) != null;
        if (!hasMantle) {
            return;
        }
        if (side.isServer()) {
            if (!(pl instanceof ServerPlayerEntity) || MiscUtils.isPlayerFakeMP((ServerPlayerEntity)pl)) {
                return;
            }
            this.tickServer(pl);
        } else {
            this.tickClient(pl);
        }
    }

    @Nonnull
    protected CompoundNBT getData(LivingEntity entity) {
        if (entity == null) {
            return new CompoundNBT();
        }
        ItemStack stack = entity.func_184582_a(EquipmentSlotType.CHEST);
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemMantle)) {
            return new CompoundNBT();
        }
        return NBTHelper.getPersistentData(stack);
    }

    public EnumSet<TickEvent.Type> getHandledTypes() {
        return EnumSet.of(TickEvent.Type.PLAYER);
    }

    public boolean canFire(TickEvent.Phase phase) {
        return phase == TickEvent.Phase.END;
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public static class Config
    extends ConfigEntry {
        private final boolean defaultEnabled = true;
        public ForgeConfigSpec.BooleanValue enabled;

        public Config(String constellationName) {
            super(String.format("constellation.mantle.%s", constellationName));
        }

        @Override
        public void createEntries(ForgeConfigSpec.Builder cfgBuilder) {
            this.enabled = cfgBuilder.comment("Set this to false to disable this mantle effect").translation(this.translationKey("enabled")).define("enabled", this.defaultEnabled);
        }
    }
}

