/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.world;

import hellfirepvp.astralsorcery.common.constellation.world.DayTimeHelper;
import hellfirepvp.astralsorcery.common.constellation.world.WorldContext;
import hellfirepvp.astralsorcery.common.data.config.entry.GeneralConfig;
import java.util.Random;
import net.minecraft.world.World;

public class CelestialEventHandler {
    private final WorldContext ctx;
    private boolean solarEclipse = false;
    private boolean dayOfSolarEclipse = false;
    private int prevSolarEclipseTick = 0;
    private int solarEclipseTick = 0;
    private boolean lunarEclipse = false;
    private boolean dayOfLunarEclipse = false;
    private int prevLunarEclipseTick = 0;
    private int lunarEclipseTick = 0;

    CelestialEventHandler(WorldContext context) {
        this.ctx = context;
    }

    public boolean isSolarEclipseActive() {
        return this.solarEclipse;
    }

    public boolean isLunarEclipseActive() {
        return this.lunarEclipse;
    }

    public boolean isDayOfSolarEclipse() {
        return this.dayOfSolarEclipse;
    }

    public boolean isDayOfLunarEclipse() {
        return this.dayOfLunarEclipse;
    }

    public int getSolarEclipseTick() {
        return this.solarEclipseTick;
    }

    public int getLunarEclipseTick() {
        return this.lunarEclipseTick;
    }

    public float getSolarEclipsePercent() {
        if (!this.isSolarEclipseActive()) {
            return 0.0f;
        }
        float tick = this.ctx.getCelestialHandler().getSolarEclipseTick() - DayTimeHelper.getSolarEclipseHalfDuration();
        return Math.abs(tick /= (float)DayTimeHelper.getSolarEclipseHalfDuration());
    }

    void tick(World world) {
        int suggestedDayLength;
        Random r = this.ctx.getRandom();
        for (int i = 0; i < 10 + r.nextInt(10); ++i) {
            r.nextLong();
        }
        int rand = r.nextInt(36);
        if (rand >= 18) {
            rand -= 36;
        }
        int offset = 36 - rand;
        int repeat = 36;
        long wTime = world.func_72820_D();
        int solarTime = (int)((wTime - (long)(offset * (suggestedDayLength = ((Integer)GeneralConfig.CONFIG.dayLength.get()).intValue()))) % (long)(repeat * suggestedDayLength));
        this.dayOfSolarEclipse = solarTime >= 0 && solarTime < suggestedDayLength;
        int midSOffset = suggestedDayLength / 4;
        if (wTime > (long)suggestedDayLength && solarTime > midSOffset - DayTimeHelper.getSolarEclipseHalfDuration() && solarTime < midSOffset + DayTimeHelper.getSolarEclipseHalfDuration()) {
            this.solarEclipse = true;
            this.prevSolarEclipseTick = this.solarEclipseTick;
            this.solarEclipseTick = solarTime - (midSOffset - DayTimeHelper.getSolarEclipseHalfDuration());
        } else {
            this.solarEclipse = false;
            this.solarEclipseTick = 0;
            this.prevSolarEclipseTick = 0;
        }
        repeat = 68;
        int lunarTime = (int)(wTime % (long)(repeat * suggestedDayLength));
        this.dayOfLunarEclipse = lunarTime >= 0 && lunarTime < suggestedDayLength;
        int midLOffset = Math.round((float)suggestedDayLength * 0.75f);
        if (wTime > (long)suggestedDayLength && lunarTime > midLOffset - DayTimeHelper.getLunarEclipseHalfDuration() && lunarTime < midLOffset + DayTimeHelper.getLunarEclipseHalfDuration()) {
            this.lunarEclipse = true;
            this.prevLunarEclipseTick = this.lunarEclipseTick;
            this.lunarEclipseTick = lunarTime - (midLOffset - DayTimeHelper.getLunarEclipseHalfDuration());
        } else {
            this.lunarEclipse = false;
            this.lunarEclipseTick = 0;
            this.prevLunarEclipseTick = 0;
        }
    }
}

