/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.nojson.starlight;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.VFXAlphaFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXMotionController;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.common.crafting.helper.ingredient.CrystalIngredient;
import hellfirepvp.astralsorcery.common.crafting.nojson.starlight.LiquidStarlightRecipe;
import hellfirepvp.astralsorcery.common.crystal.CrystalAttributeItem;
import hellfirepvp.astralsorcery.common.crystal.CrystalAttributes;
import hellfirepvp.astralsorcery.common.crystal.CrystalGenerator;
import hellfirepvp.astralsorcery.common.data.config.entry.CraftingConfig;
import hellfirepvp.astralsorcery.common.item.ItemStardust;
import hellfirepvp.astralsorcery.common.item.crystal.ItemCrystalBase;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.lib.ItemsAS;
import hellfirepvp.astralsorcery.common.tile.TileCelestialCrystals;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FormCelestialCrystalClusterRecipe
extends LiquidStarlightRecipe {
    public FormCelestialCrystalClusterRecipe() {
        super(AstralSorcery.key("form_celestial_crystal_cluster"));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Ingredient> getInputForRender() {
        return Arrays.asList(new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)ItemsAS.STARDUST)}), new CrystalIngredient(false, false)});
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Ingredient> getOutputForRender() {
        return Collections.singletonList(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)BlocksAS.CELESTIAL_CRYSTAL_CLUSTER)}));
    }

    @Override
    public boolean doesStartRecipe(ItemStack item) {
        if (!((Boolean)CraftingConfig.CONFIG.liquidStarlightFormCelestialCrystalCluster.get()).booleanValue()) {
            return false;
        }
        return item.func_77973_b() instanceof ItemStardust;
    }

    @Override
    public boolean matches(ItemEntity trigger, World world, BlockPos at) {
        List<Entity> otherEntities = this.getEntitiesInBlock((IWorld)world, at);
        otherEntities.remove(trigger);
        Optional<Entity> crystalEntity = otherEntities.stream().filter(e -> e instanceof ItemEntity).filter(e -> ((ItemEntity)e).func_92059_d().func_77973_b() instanceof ItemCrystalBase).findFirst();
        return crystalEntity.isPresent() && otherEntities.size() == 1;
    }

    @Override
    public void doServerCraftTick(ItemEntity trigger, World world, BlockPos at) {
        TileCelestialCrystals cluster;
        ItemStack crystalFound;
        Random r = new Random(MathHelper.func_180186_a((Vec3i)at));
        if (!world.func_201670_d() && this.getAndIncrementCraftingTick((Entity)trigger) > 125 + r.nextInt(40) && this.consumeItemEntityInBlock((IWorld)world, at, ItemsAS.STARDUST) != null && (crystalFound = this.consumeItemEntityInBlock((IWorld)world, at, 1, stack -> stack.func_77973_b() instanceof ItemCrystalBase)) != null && world.func_175656_a(at, BlocksAS.CELESTIAL_CRYSTAL_CLUSTER.func_176223_P()) && (cluster = MiscUtils.getTileAt((IBlockReader)world, at, TileCelestialCrystals.class, true)) != null) {
            CrystalAttributes attr = ((CrystalAttributeItem)crystalFound.func_77973_b()).getAttributes(crystalFound);
            ItemStack targetCrystal = new ItemStack((IItemProvider)ItemsAS.CELESTIAL_CRYSTAL);
            ((CrystalAttributeItem)crystalFound.func_77973_b()).setAttributes(targetCrystal, attr);
            cluster.setAttributes(CrystalGenerator.upgradeProperties(targetCrystal));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void doClientEffectTick(ItemEntity trigger, World world, BlockPos at) {
        int i;
        for (i = 0; i < 3; ++i) {
            Vector3 pos = Vector3.atEntityCenter((Entity)trigger);
            MiscUtils.applyRandomOffset(pos, rand, 0.15f);
            Vector3 motion = Vector3.RotAxis.Y_AXIS.clone();
            motion.rotate(Math.toRadians(10 + rand.nextInt(20)), Vector3.RotAxis.X_AXIS).rotate((double)rand.nextFloat() * Math.PI * 2.0, Vector3.RotAxis.Y_AXIS).normalize().multiply(0.07f + rand.nextFloat() * 0.04f);
            ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(pos)).alpha(VFXAlphaFunction.FADE_OUT)).setMotion(motion)).setScaleMultiplier(0.05f + rand.nextFloat() * 0.2f)).setMaxAge(30 + rand.nextInt(20));
        }
        for (i = 0; i < 4; ++i) {
            Vector3 target = Vector3.atEntityCenter((Entity)trigger);
            Vector3 pos = target.clone().add(Vector3.random().normalize().multiply(3.0f + rand.nextFloat()));
            ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(pos)).alpha(VFXAlphaFunction.PYRAMID.andThen(VFXAlphaFunction.proximity(target::clone, 2.0f)))).motion(VFXMotionController.target(target::clone, 0.1f))).setScaleMultiplier(0.15f + rand.nextFloat() * 0.1f)).setMaxAge(20 + rand.nextInt(20));
        }
    }
}

