/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.recipe.altar;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import hellfirepvp.astralsorcery.common.block.tile.altar.AltarType;
import hellfirepvp.astralsorcery.common.crafting.helper.ingredient.FluidIngredient;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.apache.commons.lang3.StringUtils;

public class AltarRecipeGrid {
    public static final int GRID_SIZE = 5;
    public static final int MAX_INVENTORY_SIZE = 25;
    public static final AltarRecipeGrid EMPTY = new AltarRecipeGrid(new HashMap<Integer, Ingredient>(), 0, 0);
    private static final Pattern SKIP_CHARS = Pattern.compile("^\\s|_|#$");
    private final Map<Integer, Ingredient> gridParts;
    private final int width;
    private final int height;

    private AltarRecipeGrid(Map<Integer, Ingredient> gridParts) {
        this(new AltarRecipeGrid(gridParts, 5, 5));
    }

    private AltarRecipeGrid(AltarRecipeGrid other) {
        this(other.gridParts, other.width, other.height);
    }

    private AltarRecipeGrid(Map<Integer, Ingredient> gridParts, int width, int height) {
        this.gridParts = gridParts;
        this.width = width;
        this.height = height;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean containsInputs(IItemHandlerModifiable itemHandler, boolean testMirrored) {
        for (int xx = 0; xx <= 5 - this.width; ++xx) {
            for (int zz = 0; zz <= 5 - this.height; ++zz) {
                if (this.matches(itemHandler, xx, zz, false)) {
                    return true;
                }
                if (!testMirrored || !this.matches(itemHandler, xx, zz, true)) continue;
                return true;
            }
        }
        return false;
    }

    public Ingredient getIngredient(int index) {
        return this.gridParts.getOrDefault(index, Ingredient.field_193370_a);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    private boolean matches(IItemHandlerModifiable itemHandler, int xOffset, int zOffset, boolean mirrored) {
        HashSet<Integer> matchedItems = new HashSet<Integer>();
        int totalOffset = zOffset * 5 + xOffset;
        for (int x = 0; x < this.width; ++x) {
            for (int z = 0; z < this.height; ++z) {
                int slot;
                ItemStack contained;
                Ingredient expected;
                int index = x + z * 5;
                if (mirrored) {
                    index = this.width - x - 1 + z * 5;
                }
                if (!(expected = this.getIngredient(index)).test(contained = itemHandler.getStackInSlot(slot = index + totalOffset))) {
                    return false;
                }
                matchedItems.add(slot);
            }
        }
        return this.isGridEmpty(itemHandler, matchedItems);
    }

    private boolean isGridEmpty(IItemHandlerModifiable inventory, Collection<Integer> skipSlots) {
        for (int x = 0; x < 5; ++x) {
            for (int z = 0; z < 5; ++z) {
                int slot = x + z * 5;
                if (skipSlots.contains(slot) || inventory.getStackInSlot(slot).func_190926_b()) continue;
                return false;
            }
        }
        return true;
    }

    public void validate(AltarType type) {
        if (this.gridParts.isEmpty()) {
            throw new IllegalArgumentException("Altar recipe grid cannot be empty!");
        }
        for (Integer index : this.gridParts.keySet()) {
            if (!type.hasSlot(index)) {
                throw new IllegalArgumentException("Altar type " + type.name() + " has no slot at " + index);
            }
            Ingredient input = this.gridParts.get(index);
            if (!input.func_203189_d()) continue;
            throw new IllegalArgumentException("Input at " + index + " has no matching items!");
        }
    }

    public void write(PacketBuffer buffer) {
        buffer.writeInt(this.width);
        buffer.writeInt(this.height);
        buffer.writeInt(this.gridParts.size());
        this.gridParts.forEach((key, value) -> {
            buffer.writeInt(key.intValue());
            value.func_199564_a(buffer);
        });
    }

    public static AltarRecipeGrid read(PacketBuffer buffer) {
        int width = buffer.readInt();
        int height = buffer.readInt();
        int gridParts = buffer.readInt();
        HashMap<Integer, Ingredient> ingredientMap = new HashMap<Integer, Ingredient>();
        for (int i = 0; i < gridParts; ++i) {
            int slot = buffer.readInt();
            Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            ingredientMap.put(slot, ingredient);
        }
        return new AltarRecipeGrid(ingredientMap, width, height);
    }

    public void serialize(JsonObject object) {
        JsonArray pattern = new JsonArray();
        JsonObject keys = new JsonObject();
        HashMap<JsonElement, String> revMap = new HashMap<JsonElement, String>();
        HashMap<String, JsonElement> ingredientMap = new HashMap<String, JsonElement>();
        HashMap<Integer, String> patternMap = new HashMap<Integer, String>();
        char c = 'A';
        for (Map.Entry<Integer, Ingredient> entry : this.gridParts.entrySet()) {
            Integer slotIndex = entry.getKey();
            Ingredient value = entry.getValue();
            JsonElement jsonIngredient = value.func_200304_c();
            if (!revMap.containsKey(jsonIngredient)) {
                String strKey = String.valueOf(c);
                revMap.put(jsonIngredient, strKey);
                patternMap.put(slotIndex, strKey);
                ingredientMap.put(strKey, jsonIngredient);
                c = (char)(c + '\u0001');
                continue;
            }
            patternMap.put(slotIndex, (String)revMap.get(jsonIngredient));
        }
        for (int xx = 0; xx < 5; ++xx) {
            StringBuilder line = new StringBuilder();
            for (int zz = 0; zz < 5; ++zz) {
                int slotIndex = xx * 5 + zz;
                line.append(patternMap.getOrDefault(slotIndex, "_"));
            }
            pattern.add(line.toString());
        }
        object.add("pattern", (JsonElement)pattern);
        ingredientMap.forEach((key, ingredient) -> keys.add(String.valueOf(key), ingredient));
        object.add("key", (JsonElement)keys);
    }

    public static AltarRecipeGrid deserialize(AltarType type, JsonObject json) throws JsonSyntaxException {
        char c;
        int i;
        JsonArray pattern = JSONUtils.func_151214_t((JsonObject)json, (String)"pattern");
        JsonObject keys = JSONUtils.func_152754_s((JsonObject)json, (String)"key");
        HashMap<Integer, Character> patternMap = new HashMap<Integer, Character>();
        HashSet<Character> usedChars = new HashSet<Character>();
        for (i = 0; i < 25; ++i) {
            patternMap.put(i, Character.valueOf('_'));
        }
        for (i = 0; i < Math.min(pattern.size(), 5); ++i) {
            String str = JSONUtils.func_151206_a((JsonElement)pattern.get(i), (String)String.format("pattern[%s]", i));
            if (str.length() > 5) {
                throw new JsonSyntaxException("Invalid pattern: too many columns, 5 is maximum");
            }
            char[] charArray = str.toCharArray();
            for (int j = 0; j < charArray.length; ++j) {
                c = charArray[j];
                String strChar = String.valueOf(c);
                if (SKIP_CHARS.matcher(strChar).matches()) continue;
                usedChars.add(Character.valueOf(c));
                patternMap.put(i * 5 + j, Character.valueOf(c));
            }
        }
        HashMap<Integer, Ingredient> mappedIngredients = new HashMap<Integer, Ingredient>();
        for (Map.Entry jEntry : keys.entrySet()) {
            String key = (String)jEntry.getKey();
            if (key.length() != 1) {
                throw new JsonSyntaxException("Invalid Key: '" + key + "'! Keys must only be a single character!");
            }
            c = key.charAt(0);
            if (SKIP_CHARS.matcher(String.valueOf(c)).matches()) continue;
            if (!usedChars.contains(Character.valueOf(c))) {
                throw new JsonSyntaxException("Invalid Key: '" + key + "'! Not used in the pattern map!");
            }
            Ingredient i2 = Ingredient.func_199802_a((JsonElement)((JsonElement)jEntry.getValue()));
            for (int index = 0; index < 25; ++index) {
                if (((Character)patternMap.get(index)).charValue() != c) continue;
                mappedIngredients.put(index, i2);
            }
            usedChars.remove(Character.valueOf(c));
        }
        if (!usedChars.isEmpty()) {
            throw new JsonSyntaxException("The following keys are used in the pattern but don't have a key associated with them: " + usedChars);
        }
        if (mappedIngredients.isEmpty()) {
            throw new JsonSyntaxException("Empty recipe found. At least one input must be specified!");
        }
        for (Integer slot : mappedIngredients.keySet()) {
            if (type.hasSlot(slot)) continue;
            throw new JsonSyntaxException("Slot " + slot + " has an ingredient but cannot be used in altar type " + type.name());
        }
        return new AltarRecipeGrid(mappedIngredients);
    }

    public static class Builder {
        private final LinkedList<String> pattern = Lists.newLinkedList();
        private final Map<Character, Ingredient> inputMapping = Maps.newHashMap();

        public Builder patternLine(String line) {
            if (line.length() > 5) {
                throw new IllegalArgumentException("Altar recipe pattern line must not be more than 5 characters long! Passed line '" + line + "'");
            }
            if (this.pattern.size() >= 5) {
                throw new IllegalArgumentException("Altar recipe pattern must not have more than 5 lines total!");
            }
            this.pattern.add(line);
            return this;
        }

        public Builder key(Character key, Tag<Item> tagIn) {
            return this.key(key, Ingredient.func_199805_a(tagIn));
        }

        public Builder key(Character key, IItemProvider itemIn) {
            return this.key(key, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{itemIn}));
        }

        public Builder key(Character key, Fluid fluid) {
            return this.key(key, new FluidIngredient(new FluidStack(fluid, 1000)));
        }

        public Builder key(Character key, Ingredient input) {
            if (this.inputMapping.containsKey(key)) {
                throw new IllegalArgumentException("Character '" + key + "' is already defined!");
            }
            if (key.equals(Character.valueOf(' ')) || key.equals(Character.valueOf('_'))) {
                throw new IllegalArgumentException("Character ' ' (whitespace) or '_' (underscore) is reserved and cannot be defined!");
            }
            this.inputMapping.put(key, input);
            return this;
        }

        public AltarRecipeGrid build() {
            int i;
            int mostWidth = this.pattern.stream().map(String::length).max(Integer::compareTo).orElseThrow(() -> new IllegalArgumentException("No pattern is defined for altar recipe!"));
            int mostHeight = (int)this.pattern.stream().filter(s -> !s.isEmpty()).count();
            if (mostHeight == 0 || mostWidth == 0) {
                throw new IllegalArgumentException("Altar recipe grid pattern is empty!");
            }
            int shiftZ = (5 - mostHeight) / 2;
            for (i = 0; i < shiftZ; ++i) {
                this.pattern.addFirst(StringUtils.repeat((char)'_', (int)5));
            }
            for (i = 0; i < 5 - mostHeight - shiftZ; ++i) {
                this.pattern.add(StringUtils.repeat((char)'_', (int)5));
            }
            LinkedList<String> patternLines = new LinkedList<String>();
            int shiftX = (5 - mostWidth) / 2;
            for (String string : this.pattern) {
                String newLine = StringUtils.repeat((String)"_", (int)shiftX) + string + StringUtils.repeat((String)"_", (int)(5 - mostWidth - shiftX));
                patternLines.add(newLine);
            }
            HashSet<Character> foundCharacters = new HashSet<Character>();
            for (String line : patternLines) {
                for (char c : line.toCharArray()) {
                    if (SKIP_CHARS.matcher(String.valueOf(c)).matches()) continue;
                    foundCharacters.add(Character.valueOf(c));
                }
            }
            if (!this.inputMapping.keySet().containsAll(foundCharacters)) {
                String string = foundCharacters.stream().filter(key -> !this.inputMapping.containsKey(key)).map(String::valueOf).collect(Collectors.joining(", "));
                throw new IllegalArgumentException("No matching input found for characters " + string);
            }
            HashMap<Integer, Ingredient> hashMap = new HashMap<Integer, Ingredient>();
            for (int lineIndex = 0; lineIndex < patternLines.size(); ++lineIndex) {
                char[] charArray = ((String)patternLines.get(lineIndex)).toCharArray();
                for (int cIndex = 0; cIndex < charArray.length; ++cIndex) {
                    Character c = Character.valueOf(charArray[cIndex]);
                    if (SKIP_CHARS.matcher(String.valueOf(c)).matches()) continue;
                    int slotIndex = lineIndex * 5 + cIndex;
                    hashMap.put(slotIndex, this.inputMapping.get(c));
                }
            }
            return new AltarRecipeGrid(hashMap);
        }
    }
}

