/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.recipe.infusion;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.RefreshFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXAlphaFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXMotionController;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.source.FXSource;
import hellfirepvp.astralsorcery.client.effect.source.orbital.FXOrbitalInfuserLiquid;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingAtlasParticle;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.client.util.ColorizationHelper;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.common.auxiliary.ChaliceHelper;
import hellfirepvp.astralsorcery.common.crafting.recipe.LiquidInfusion;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.tile.TileChalice;
import hellfirepvp.astralsorcery.common.tile.TileInfuser;
import hellfirepvp.astralsorcery.common.util.ColorUtils;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.RecipeHelper;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.item.ItemUtils;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.awt.Color;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;

public class ActiveLiquidInfusionRecipe {
    private static final Random rand = new Random();
    private static final int CHALICE_DISTANCE = 8;
    private final LiquidInfusion recipeToCraft;
    private final UUID playerCraftingUUID;
    private int ticksCrafting = 0;
    private Set<BlockPos> supportingChalices = new HashSet<BlockPos>();
    private CompoundNBT craftingData = new CompoundNBT();
    private Object orbitalLiquid = null;

    public ActiveLiquidInfusionRecipe(World world, BlockPos center, LiquidInfusion recipeToCraft, UUID playerCraftingUUID) {
        this(recipeToCraft, playerCraftingUUID);
        if (this.recipeToCraft.acceptsChaliceInput()) {
            this.findChalices(world, center);
        }
    }

    private ActiveLiquidInfusionRecipe(LiquidInfusion recipeToCraft, UUID playerCraftingUUID) {
        this.recipeToCraft = recipeToCraft;
        this.playerCraftingUUID = playerCraftingUUID;
    }

    private void findChalices(World world, BlockPos center) {
        ChaliceHelper.findNearbyChalicesCombined(world, center, this.getChaliceRequiredFluidInput(), 8).ifPresent(chalices -> chalices.forEach(chalice -> this.supportingChalices.add(chalice.func_174877_v())));
    }

    public boolean matches(TileInfuser infuser) {
        if (!this.getRecipeToCraft().matches(infuser, this.tryGetCraftingPlayerServer(), LogicalSide.SERVER)) {
            return false;
        }
        if (!this.supportingChalices.isEmpty() && !ChaliceHelper.doChalicesContainCombined(infuser.func_145831_w(), this.supportingChalices, this.getChaliceRequiredFluidInput())) {
            this.supportingChalices.clear();
        }
        return true;
    }

    public void tick() {
        ++this.ticksCrafting;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tickClient(TileInfuser infuser) {
        int i;
        FluidStack required = new FluidStack(this.getRecipeToCraft().getLiquidInput(), 1000);
        if (this.orbitalLiquid == null || ((FXOrbitalInfuserLiquid)this.orbitalLiquid).isRemoved()) {
            ResourceLocation recipeName = this.getRecipeToCraft().func_199560_c();
            this.orbitalLiquid = EffectHelper.spawnSource((FXSource)((EntityComplexFX)new FXOrbitalInfuserLiquid(new Vector3(infuser).add(0.5f, 0.0f, 0.5f), required).setOrbitAxis(Vector3.RotAxis.Y_AXIS).setOrbitRadius(2.0).setBranches(4).setMaxAge(300)).refresh(RefreshFunction.tileExistsAnd(infuser, (tInfuser, fx) -> tInfuser.getActiveRecipe() != null && recipeName.equals((Object)tInfuser.getActiveRecipe().getRecipeToCraft().func_199560_c()))));
            ((FXOrbitalInfuserLiquid)this.orbitalLiquid).setActive();
        }
        for (i = 0; i < 2; ++i) {
            this.playLiquidEffect(infuser, required);
        }
        for (i = 0; i < 7; ++i) {
            this.playLiquidPoolEffect(infuser, required);
        }
        if (!this.supportingChalices.isEmpty()) {
            this.playLiquidDrawEffect(infuser, required);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playLiquidDrawEffect(TileInfuser infuser, FluidStack required) {
        Set<BlockPos> chalices = this.supportingChalices;
        if (chalices.isEmpty()) {
            return;
        }
        Vector3 target = new Vector3(infuser).add(0.5, 1.1, 0.5);
        TextureAtlasSprite tas = RenderingUtils.getParticleTexture(required);
        VFXColorFunction<EntityVisualFX> colorFn = (fx, pTicks) -> new Color(ColorUtils.getOverlayColor(required));
        for (int i = 0; i < 2 * this.supportingChalices.size(); ++i) {
            BlockPos chalice = MiscUtils.getRandomEntry(chalices, rand);
            Vector3 pos = new Vector3((Vec3i)chalice).add(0.5, 1.4, 0.5);
            int maxAge = 30;
            maxAge = (int)((double)maxAge * Math.max(pos.distance(target) / 3.0, 1.0));
            if (rand.nextInt(3) != 0) {
                MiscUtils.applyRandomOffset(pos, rand, 0.3f);
                ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingAtlasParticle)((FXFacingAtlasParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_ATLAS_PARTICLE).spawn(pos)).setSprite(tas)).selectFraction(0.2f)).setScaleMultiplier(0.01f + rand.nextFloat() * 0.04f)).color(colorFn)).alpha(VFXAlphaFunction.proximity(() -> target, 2.0f).andThen(VFXAlphaFunction.FADE_OUT))).motion(VFXMotionController.target(target::clone, 0.08f))).setMaxAge(maxAge);
                continue;
            }
            MiscUtils.applyRandomOffset(pos, rand, 0.4f);
            ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(pos)).setScaleMultiplier(0.15f + rand.nextFloat() * 0.1f)).color(colorFn)).alpha(VFXAlphaFunction.proximity(() -> target, 2.0f).andThen(VFXAlphaFunction.FADE_OUT))).motion(VFXMotionController.target(target::clone, 0.08f))).setMaxAge(maxAge);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playLiquidEffect(TileInfuser infuser, FluidStack required) {
        Vector3 vec = infuser.getRandomInfuserOffset();
        MiscUtils.applyRandomOffset(vec, rand, 0.05f);
        ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingAtlasParticle)((FXFacingAtlasParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_ATLAS_PARTICLE).spawn(vec)).setSprite(RenderingUtils.getParticleTexture(required))).selectFraction(0.2f)).setScaleMultiplier(0.03f + rand.nextFloat() * 0.03f)).color((fx, pTicks) -> new Color(ColorUtils.getOverlayColor(required)))).alpha(VFXAlphaFunction.FADE_OUT)).motion(VFXMotionController.target(() -> new Vector3(infuser).add(0.5, 1.1, 0.5), 0.3f))).setMaxAge(40);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playLiquidPoolEffect(TileInfuser infuser, FluidStack required) {
        List posList = TileInfuser.getLiquidOffsets().stream().map(pos -> pos.func_177971_a((Vec3i)infuser.func_174877_v())).collect(Collectors.toList());
        BlockPos at = (BlockPos)MiscUtils.getRandomEntry(posList, rand);
        if (at != null) {
            ((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(new Vector3((Vec3i)at).add(rand.nextFloat(), 1.0f, rand.nextFloat()))).setScaleMultiplier(0.1f + rand.nextFloat() * 0.15f)).color((fx, pTicks) -> ColorizationHelper.getColor(required).orElse(Color.WHITE))).setAlphaMultiplier(1.0f)).alpha(VFXAlphaFunction.FADE_OUT)).setMotion(new Vector3(0.0, 0.15, 0.0))).setGravityStrength(0.005f + rand.nextFloat() * 0.008f);
        }
    }

    public void clearEffects() {
        if (this.orbitalLiquid != null) {
            this.clearClientEffect();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clearClientEffect() {
        ((FXOrbitalInfuserLiquid)this.orbitalLiquid).requestRemoval();
    }

    public void createItemOutputs(TileInfuser infuser, Consumer<ItemStack> output) {
        Consumer<ItemStack> informer = stack -> ResearchManager.informCraftedInfuser(infuser, this, stack);
        ItemStack inputStack = infuser.getItemInput();
        Consumer<ItemStack> handleCrafted = informer.andThen(output);
        if (this.recipeToCraft.doesCopyNBTToOutputs()) {
            handleCrafted = ((Consumer<ItemStack>)stack -> stack.func_77982_d(inputStack.func_77978_p())).andThen(handleCrafted);
        }
        handleCrafted.accept(this.getRecipeToCraft().getOutput(inputStack));
        this.getRecipeToCraft().onRecipeCompletion(infuser);
    }

    public void consumeInputs(TileInfuser infuser) {
        ItemUtils.decrementItem(infuser::getItemInput, infuser::setItemInput, infuser::dropItemOnTop);
    }

    public void consumeFluidsInput(TileInfuser infuser) {
        float chaliceSupplied = 0.0f;
        if (!this.supportingChalices.isEmpty()) {
            FluidStack required = this.getChaliceRequiredFluidInput();
            Optional<List<TileChalice>> chalices = ChaliceHelper.findNearbyChalicesCombined(infuser.func_145831_w(), infuser.func_174877_v(), required, 8);
            if (chalices.isPresent()) {
                FluidStack left = required.copy();
                for (TileChalice chalice : chalices.get()) {
                    left.shrink(chalice.getTank().drain(left, IFluidHandler.FluidAction.EXECUTE).getAmount());
                    if (!left.isEmpty()) continue;
                    break;
                }
                if (left.isEmpty()) {
                    return;
                }
                chaliceSupplied = (float)required.getAmount() / (float)left.getAmount();
            }
        }
        LiquidInfusion infusion = this.getRecipeToCraft();
        float chance = infusion.getConsumptionChance() * (1.0f - chaliceSupplied);
        if (infusion.doesConsumeMultipleFluids()) {
            for (BlockPos at : TileInfuser.getLiquidOffsets()) {
                if (!(rand.nextFloat() < chance)) continue;
                infuser.func_145831_w().func_180501_a(at, Blocks.field_150350_a.func_176223_P(), 11);
            }
        } else {
            BlockPos at = MiscUtils.getRandomEntry(TileInfuser.getLiquidOffsets(), rand).func_177971_a((Vec3i)infuser.func_174877_v());
            if (rand.nextFloat() < chance) {
                infuser.func_145831_w().func_180501_a(at, Blocks.field_150350_a.func_176223_P(), 11);
            }
        }
    }

    public FluidStack getChaliceRequiredFluidInput() {
        int amount = Math.round(1000.0f * this.recipeToCraft.getConsumptionChance());
        amount = (int)((double)amount * 0.75);
        amount = this.recipeToCraft.doesConsumeMultipleFluids() ? amount * TileInfuser.getLiquidOffsets().size() : amount;
        return new FluidStack(this.getRecipeToCraft().getLiquidInput(), amount);
    }

    public int getTotalCraftingTime() {
        int tickTime = this.recipeToCraft.getCraftingTickTime();
        int fixTime = Math.round((float)tickTime * 0.25f);
        int chaliceTime = Math.round((float)tickTime * 0.75f);
        return fixTime + (chaliceTime /= this.supportingChalices.size() + 1);
    }

    public CompoundNBT getCraftingData() {
        return this.craftingData;
    }

    public UUID getPlayerCraftingUUID() {
        return this.playerCraftingUUID;
    }

    public int getTicksCrafting() {
        return this.ticksCrafting;
    }

    public LiquidInfusion getRecipeToCraft() {
        return this.recipeToCraft;
    }

    public boolean isFinished() {
        return this.getTicksCrafting() >= this.getTotalCraftingTime();
    }

    @Nullable
    public PlayerEntity tryGetCraftingPlayerServer() {
        MinecraftServer srv = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
        return srv.func_184103_al().func_177451_a(this.getPlayerCraftingUUID());
    }

    @Nullable
    public static ActiveLiquidInfusionRecipe deserialize(CompoundNBT compound, @Nullable ActiveLiquidInfusionRecipe prev) {
        RecipeManager mgr = RecipeHelper.getRecipeManager();
        if (mgr == null) {
            return null;
        }
        ResourceLocation recipeKey = new ResourceLocation(compound.func_74779_i("recipeToCraft"));
        Optional recipe = mgr.func_215367_a(recipeKey);
        if (!recipe.isPresent() || !(recipe.get() instanceof LiquidInfusion)) {
            AstralSorcery.log.info("Recipe with unknown/invalid name found: " + recipeKey);
            return null;
        }
        LiquidInfusion altarRecipe = (LiquidInfusion)recipe.get();
        UUID uuidCraft = compound.func_186857_a("playerCraftingUUID");
        int tick = compound.func_74762_e("ticksCrafting");
        ListNBT chalices = compound.func_150295_c("supportingChalices", 10);
        HashSet<BlockPos> chalicePositions = new HashSet<BlockPos>();
        for (int i = 0; i < chalices.size(); ++i) {
            CompoundNBT tag = chalices.func_150305_b(i);
            chalicePositions.add(NBTHelper.readBlockPosFromNBT(tag));
        }
        ActiveLiquidInfusionRecipe task = new ActiveLiquidInfusionRecipe(altarRecipe, uuidCraft);
        task.ticksCrafting = tick;
        task.craftingData = compound.func_74775_l("craftingData");
        task.supportingChalices.addAll(chalicePositions);
        if (prev != null && prev.orbitalLiquid != null) {
            task.orbitalLiquid = prev.orbitalLiquid;
        }
        return task;
    }

    @Nonnull
    public CompoundNBT serialize() {
        ListNBT chalicePositions = new ListNBT();
        this.supportingChalices.forEach(pos -> chalicePositions.add((Object)NBTHelper.writeBlockPosToNBT(pos, new CompoundNBT())));
        CompoundNBT compound = new CompoundNBT();
        compound.func_74778_a("recipeToCraft", this.getRecipeToCraft().func_199560_c().toString());
        compound.func_186854_a("playerCraftingUUID", this.getPlayerCraftingUUID());
        compound.func_74768_a("ticksCrafting", this.getTicksCrafting());
        compound.func_218657_a("craftingData", (INBT)this.craftingData);
        compound.func_218657_a("supportingChalices", (INBT)chalicePositions);
        return compound;
    }
}

