/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crystal;

import hellfirepvp.astralsorcery.common.crystal.CalculationContext;
import hellfirepvp.astralsorcery.common.crystal.CrystalAttributeItem;
import hellfirepvp.astralsorcery.common.crystal.CrystalAttributes;
import hellfirepvp.astralsorcery.common.crystal.source.Ritual;
import hellfirepvp.astralsorcery.common.lib.CrystalPropertiesAS;
import hellfirepvp.astralsorcery.common.starlight.transmission.base.crystal.IndependentCrystalSource;
import hellfirepvp.astralsorcery.common.tile.TileRitualPedestal;
import hellfirepvp.astralsorcery.common.tile.network.StarlightReceiverRitualPedestal;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;

public class CrystalCalculations {
    private static final float TICKS_PER_HOUR = 72000.0f;

    private CrystalCalculations() {
    }

    public static double calculate(double value, CrystalAttributes attributes, CalculationContext context) {
        for (CrystalAttributes.Attribute attribute : attributes.getCrystalAttributes()) {
            value = attribute.getProperty().modify(value, attribute.getTier(), context);
        }
        return value;
    }

    public static double getRitualEffectRangeFactor(StarlightReceiverRitualPedestal pedestal, CrystalAttributes attributes) {
        return CrystalCalculations.getRitualEffectRangeFactor(CrystalPropertiesAS.Sources.SOURCE_RITUAL_PEDESTAL.createInstance(pedestal), attributes);
    }

    public static double getRitualEffectRangeFactor(TileRitualPedestal pedestal, CrystalAttributes attributes) {
        return CrystalCalculations.getRitualEffectRangeFactor(CrystalPropertiesAS.Sources.SOURCE_TILE_RITUAL_PEDESTAL.createInstance(pedestal), attributes);
    }

    private static double getRitualEffectRangeFactor(Ritual pedestalSrc, CrystalAttributes attributes) {
        CalculationContext ctx = CalculationContext.Builder.newBuilder().fromSource(pedestalSrc).addUsage(CrystalPropertiesAS.Usages.USE_RITUAL_RANGE).build();
        return CrystalCalculations.calculate(1.0, attributes, ctx);
    }

    public static double getRitualCostReductionFactor(StarlightReceiverRitualPedestal pedestal, CrystalAttributes attributes) {
        CalculationContext ctx = CalculationContext.Builder.newBuilder().fromSource(CrystalPropertiesAS.Sources.SOURCE_RITUAL_PEDESTAL.createInstance(pedestal)).addUsage(CrystalPropertiesAS.Usages.USE_RITUAL_EFFECT).build();
        return 1.0 / CrystalCalculations.calculate(1.0, attributes, ctx);
    }

    public static int getSizeCraftingAmount(CrystalAttributes attributes) {
        int amt = 1;
        CrystalAttributes.Attribute sizeAttr = attributes.getAttribute(CrystalPropertiesAS.Properties.PROPERTY_SIZE);
        if (sizeAttr != null) {
            amt += 2 * sizeAttr.getTier();
        }
        return amt;
    }

    public static float getCollectorCrystalCollectionRate(IndependentCrystalSource collectorSource) {
        CalculationContext ctx = CalculationContext.Builder.newBuilder().fromSource(CrystalPropertiesAS.Sources.SOURCE_COLLECTOR_CRYSTAL.createInstance(collectorSource)).addUsage(CrystalPropertiesAS.Usages.USE_COLLECTOR_CRYSTAL).build();
        CrystalAttributes attr = collectorSource.getCrystalAttributes();
        return (float)CrystalCalculations.calculate(1.0, attr, ctx);
    }

    public static float getCrystalCollectionRate(CrystalAttributes attributes) {
        CalculationContext ctx = CalculationContext.Builder.newBuilder().addUsage(CrystalPropertiesAS.Usages.USE_COLLECTOR_CRYSTAL).build();
        return (float)CrystalCalculations.calculate(1.0, attributes, ctx);
    }

    public static float getThroughputMultiplier(CrystalAttributes attributes) {
        CalculationContext ctx = CalculationContext.Builder.newBuilder().addUsage(CrystalPropertiesAS.Usages.USE_LENS_TRANSFER).build();
        return MathHelper.func_76131_a((float)((float)CrystalCalculations.calculate(1.0, attributes, ctx)), (float)0.0f, (float)1.0f);
    }

    public static int getToolDurability(int durability, ItemStack tool) {
        CrystalAttributes attr;
        if (tool.func_77973_b() instanceof CrystalAttributeItem && (attr = ((CrystalAttributeItem)tool.func_77973_b()).getAttributes(tool)) != null) {
            CalculationContext ctx = CalculationContext.Builder.newBuilder().addUsage(CrystalPropertiesAS.Usages.USE_TOOL_DURABILITY).build();
            durability = (int)Math.round((double)durability * CrystalCalculations.calculate(1.0, attr, ctx));
        }
        return durability;
    }

    public static float getToolEfficiency(float efficiency, ItemStack tool) {
        CrystalAttributes attr;
        if (tool.func_77973_b() instanceof CrystalAttributeItem && (attr = ((CrystalAttributeItem)tool.func_77973_b()).getAttributes(tool)) != null) {
            CalculationContext ctx = CalculationContext.Builder.newBuilder().addUsage(CrystalPropertiesAS.Usages.USE_TOOL_EFFECTIVENESS).build();
            efficiency = (float)((double)efficiency * CrystalCalculations.calculate(1.0, attr, ctx));
        }
        return efficiency;
    }
}

