/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.config.registry;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.common.data.config.base.ConfigDataAdapter;
import hellfirepvp.astralsorcery.common.data.config.registry.sets.OreBlockRarityEntry;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.tags.Tag;
import net.minecraftforge.common.Tags;

public class OreBlockRarityRegistry
extends ConfigDataAdapter<OreBlockRarityEntry> {
    public static final OreBlockRarityRegistry STONE_ENRICHMENT = new OreBlockRarityRegistry("perk_stone_enrichment_ore");
    public static final OreBlockRarityRegistry MINERALIS_RITUAL = new OreBlockRarityRegistry("mineralis_ritual_ore");
    private final String fileName;

    private OreBlockRarityRegistry(String fileName) {
        this.fileName = fileName;
    }

    @Nullable
    public Block getRandomBlock(Random rand) {
        List entries = this.getConfiguredValues();
        HashSet<OreBlockRarityEntry> visitedEntires = new HashSet<OreBlockRarityEntry>();
        while (visitedEntires.size() < entries.size()) {
            OreBlockRarityEntry entry = MiscUtils.getWeightedRandomEntry(entries.stream().filter(e -> !visitedEntires.contains(e)).collect(Collectors.toList()), rand, OreBlockRarityEntry::getWeight);
            if (entry != null) {
                visitedEntires.add(entry);
                Block b = entry.getRandomBlock(rand);
                if (b == null) continue;
                return b;
            }
            return null;
        }
        return null;
    }

    @Override
    public List<OreBlockRarityEntry> getDefaultValues() {
        return Lists.newArrayList((Object[])new OreBlockRarityEntry[]{new OreBlockRarityEntry((Tag<Block>)Tags.Blocks.ORES_COAL, 5200), new OreBlockRarityEntry((Tag<Block>)Tags.Blocks.ORES_IRON, 2500), new OreBlockRarityEntry((Tag<Block>)Tags.Blocks.ORES_GOLD, 550), new OreBlockRarityEntry((Tag<Block>)Tags.Blocks.ORES_LAPIS, 360), new OreBlockRarityEntry((Tag<Block>)Tags.Blocks.ORES_REDSTONE, 700), new OreBlockRarityEntry((Tag<Block>)Tags.Blocks.ORES_DIAMOND, 120), new OreBlockRarityEntry((Tag<Block>)Tags.Blocks.ORES_EMERALD, 100)});
    }

    @Override
    public String getSectionName() {
        return this.fileName;
    }

    @Override
    public String getCommentDescription() {
        return "Format: '<tagName>;<integerWeight>' Defines random-weighted ore-selection data. Define block-tags to select from here with associated weight. Specific mods can be blacklisted in the general AstralSorcery config in 'modidOreBlacklist'.";
    }

    @Override
    public String getTranslationKey() {
        return this.translationKey("data");
    }

    @Override
    public Predicate<Object> getValidator() {
        return obj -> obj instanceof String;
    }

    @Override
    @Nullable
    public OreBlockRarityEntry deserialize(String string) throws IllegalArgumentException {
        return OreBlockRarityEntry.deserialize(string);
    }
}

