/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.config.registry.sets;

import hellfirepvp.astralsorcery.common.data.config.base.ConfigDataSet;
import hellfirepvp.astralsorcery.common.data.config.entry.GeneralConfig;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;

public class OreBlockRarityEntry
implements ConfigDataSet {
    private final Tag<Block> blockTag;
    private final int weight;

    public OreBlockRarityEntry(Tag<Block> blockTag, int weight) {
        this.blockTag = blockTag;
        this.weight = weight;
    }

    public int getWeight() {
        return this.weight;
    }

    @Nullable
    public Block getRandomBlock(Random rand) {
        return (Block)MiscUtils.getRandomEntry(this.blockTag.func_199885_a().stream().filter(item -> !((List)GeneralConfig.CONFIG.modidOreBlacklist.get()).contains(item.getRegistryName().func_110624_b())).collect(Collectors.toList()), rand);
    }

    @Nullable
    public static OreBlockRarityEntry deserialize(String str) throws IllegalArgumentException {
        int weight;
        String[] split = str.split(";");
        if (split.length != 2) {
            return null;
        }
        ResourceLocation keyBlockTag = new ResourceLocation(split[0]);
        Tag blockTag = BlockTags.func_199896_a().func_199910_a(keyBlockTag);
        if (blockTag == null) {
            return null;
        }
        String strWeight = split[1];
        try {
            weight = Integer.parseInt(strWeight);
        }
        catch (NumberFormatException exc) {
            return null;
        }
        return new OreBlockRarityEntry((Tag<Block>)blockTag, weight);
    }

    @Override
    @Nonnull
    public String serialize() {
        return this.blockTag.func_199886_b().toString() + ";" + this.weight;
    }
}

