/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.sync.client;

import hellfirepvp.astralsorcery.common.data.sync.base.ClientData;
import hellfirepvp.astralsorcery.common.data.sync.base.ClientDataReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.DimensionManager;

public class ClientLightConnections
extends ClientData<ClientLightConnections> {
    private final Map<DimensionType, Map<BlockPos, Set<BlockPos>>> clientPosBuffer = new HashMap<DimensionType, Map<BlockPos, Set<BlockPos>>>();

    @Nonnull
    public Map<BlockPos, Set<BlockPos>> getClientConnections(DimensionType dimType) {
        return this.clientPosBuffer.getOrDefault(dimType, new HashMap());
    }

    @Override
    public void clear(DimensionType dimId) {
        this.clientPosBuffer.remove(dimId);
    }

    @Override
    public void clearClient() {
        this.clientPosBuffer.clear();
    }

    public static class Reader
    extends ClientDataReader<ClientLightConnections> {
        @Override
        public void readFromIncomingFullSync(ClientLightConnections cl, CompoundNBT compound) {
            cl.clientPosBuffer.clear();
            for (String dimTypeKey : compound.func_150296_c()) {
                DimensionType type = DimensionManager.getRegistry().func_218349_b(new ResourceLocation(dimTypeKey)).orElse(null);
                if (type == null) continue;
                HashMap<BlockPos, Set> posMap = new HashMap<BlockPos, Set>();
                ListNBT list = compound.func_150295_c(dimTypeKey, 10);
                for (INBT iTag : list) {
                    CompoundNBT tag = (CompoundNBT)iTag;
                    BlockPos start = BlockPos.func_218283_e((long)tag.func_74763_f("start"));
                    BlockPos end = BlockPos.func_218283_e((long)tag.func_74763_f("end"));
                    posMap.computeIfAbsent(start, s -> new HashSet()).add(end);
                }
                cl.clientPosBuffer.put(type, posMap);
            }
        }

        @Override
        public void readFromIncomingDiff(ClientLightConnections cl, CompoundNBT compound) {
            HashSet<String> clearedDimensions = new HashSet<String>();
            for (INBT dimKeyNBT : compound.func_150295_c("clear", 8)) {
                String dimKey = dimKeyNBT.func_150285_a_();
                DimensionType type = DimensionManager.getRegistry().func_218349_b(new ResourceLocation(dimKey)).orElse(null);
                if (type != null) {
                    cl.clientPosBuffer.remove(type);
                }
                clearedDimensions.add(dimKey);
            }
            for (String dimTypeKey : compound.func_150296_c()) {
                if (clearedDimensions.contains(dimTypeKey)) continue;
                DimensionType type = DimensionManager.getRegistry().func_218349_b(new ResourceLocation(dimTypeKey)).orElse(null);
                Map posMap = cl.clientPosBuffer.computeIfAbsent(type, d -> new HashMap());
                ListNBT list = compound.func_150295_c(dimTypeKey, 10);
                for (INBT iTag : list) {
                    CompoundNBT tag = (CompoundNBT)iTag;
                    BlockPos start = BlockPos.func_218283_e((long)tag.func_74763_f("start"));
                    BlockPos end = BlockPos.func_218283_e((long)tag.func_74763_f("end"));
                    boolean newConnection = tag.func_74767_n("connect");
                    if (newConnection) {
                        posMap.computeIfAbsent(start, s -> new HashSet()).add(end);
                        continue;
                    }
                    Set endPoints = (Set)posMap.get(start);
                    if (endPoints == null || !endPoints.remove(end) || !endPoints.isEmpty()) continue;
                    posMap.remove(start);
                }
            }
        }
    }
}

