/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.sync.client;

import hellfirepvp.astralsorcery.common.base.patreon.PatreonEffect;
import hellfirepvp.astralsorcery.common.base.patreon.PatreonEffectHelper;
import hellfirepvp.astralsorcery.common.base.patreon.entity.PatreonPartialEntity;
import hellfirepvp.astralsorcery.common.data.sync.base.ClientData;
import hellfirepvp.astralsorcery.common.data.sync.base.ClientDataReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.fml.LogicalSide;

public class ClientPatreonFlares
extends ClientData<ClientPatreonFlares> {
    private final Map<UUID, Set<PatreonPartialEntity>> entitiesClient = new HashMap<UUID, Set<PatreonPartialEntity>>();

    @Nonnull
    public Collection<UUID> getOwners() {
        return this.entitiesClient.keySet();
    }

    @Nonnull
    public Collection<PatreonPartialEntity> getEntities(UUID playerUUID) {
        return this.entitiesClient.getOrDefault(playerUUID, Collections.emptySet());
    }

    @Nonnull
    public Collection<Collection<PatreonPartialEntity>> getEntities() {
        return new ArrayList<Collection<PatreonPartialEntity>>(this.entitiesClient.values());
    }

    @Override
    public void clear(DimensionType dimType) {
    }

    @Override
    public void clearClient() {
        this.entitiesClient.clear();
    }

    public static class Reader
    extends ClientDataReader<ClientPatreonFlares> {
        @Override
        public void readFromIncomingFullSync(ClientPatreonFlares data, CompoundNBT compound) {
            data.entitiesClient.clear();
            ListNBT entities = compound.func_150295_c("entities", 10);
            for (INBT iNBT : entities) {
                CompoundNBT tag = (CompoundNBT)iNBT;
                UUID playerUUID = tag.func_186857_a("playerUUID");
                HashSet<PatreonPartialEntity> entitySet = new HashSet<PatreonPartialEntity>();
                ListNBT entityList = tag.func_150295_c("entityList", 10);
                for (INBT iEntityTag : entityList) {
                    PatreonPartialEntity entity;
                    CompoundNBT entityNBT = (CompoundNBT)iEntityTag;
                    UUID effectUUID = entityNBT.func_186857_a("id");
                    PatreonEffect effect = PatreonEffectHelper.getPatreonEffects(LogicalSide.CLIENT, playerUUID).stream().filter(eff -> eff.getEffectUUID().equals(effectUUID)).findFirst().orElse(null);
                    if (effect == null || (entity = effect.createEntity(playerUUID)) == null) continue;
                    entity.readFromNBT(entityNBT.func_74775_l("data"));
                    entitySet.add(entity);
                }
                data.entitiesClient.put(playerUUID, entitySet);
            }
        }

        @Override
        public void readFromIncomingDiff(ClientPatreonFlares data, CompoundNBT compound) {
            ListNBT entities = compound.func_150295_c("updates", 10);
            for (INBT iNBT : entities) {
                CompoundNBT tag = (CompoundNBT)iNBT;
                UUID playerUUID = tag.func_186857_a("playerUUID");
                Set entitySet = data.entitiesClient.computeIfAbsent(playerUUID, p -> new HashSet());
                ListNBT entityList = tag.func_150295_c("entityList", 10);
                for (INBT iEntityTag : entityList) {
                    CompoundNBT entityNBT = (CompoundNBT)iEntityTag;
                    UUID effectUUID = entityNBT.func_186857_a("id");
                    PatreonEffect effect = PatreonEffectHelper.getPatreonEffects(LogicalSide.CLIENT, playerUUID).stream().filter(eff -> eff.getEffectUUID().equals(effectUUID)).findFirst().orElse(null);
                    if (effect == null) continue;
                    PatreonPartialEntity entity = entitySet.stream().filter(e -> e.getEffectUUID().equals(effectUUID)).findFirst().orElse(null);
                    if (entity == null) {
                        entity = effect.createEntity(playerUUID);
                        if (entity == null) continue;
                        entitySet.add(entity);
                    }
                    entity.readFromNBT(entityNBT.func_74775_l("data"));
                }
            }
            ListNBT removals = compound.func_150295_c("removals", 10);
            for (INBT iNBT : removals) {
                CompoundNBT tag = (CompoundNBT)iNBT;
                UUID playerUUID = tag.func_186857_a("playerUUID");
                data.entitiesClient.remove(playerUUID);
            }
        }
    }
}

