/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.sync.client;

import hellfirepvp.astralsorcery.common.data.sync.base.ClientData;
import hellfirepvp.astralsorcery.common.data.sync.base.ClientDataReader;
import hellfirepvp.astralsorcery.common.data.sync.server.DataTimeFreezeEffects;
import hellfirepvp.astralsorcery.common.util.time.TimeStopEffectHelper;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IWorld;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.DimensionManager;

public class ClientTimeFreezeEffects
extends ClientData<ClientTimeFreezeEffects> {
    private final Map<DimensionType, List<TimeStopEffectHelper>> clientActiveFreezeZones = new HashMap<DimensionType, List<TimeStopEffectHelper>>();

    @Nonnull
    public List<TimeStopEffectHelper> getTimeStopEffects(IWorld world) {
        return this.getTimeStopEffects(world.func_201675_m().func_186058_p());
    }

    @Nonnull
    public List<TimeStopEffectHelper> getTimeStopEffects(DimensionType dimType) {
        return this.clientActiveFreezeZones.getOrDefault(dimType, Collections.emptyList());
    }

    private void applyChange(DataTimeFreezeEffects.ServerSyncAction action) {
        DimensionType type = action.getDimType();
        switch (action.getType()) {
            case ADD: {
                List zones = this.clientActiveFreezeZones.computeIfAbsent(type, id -> new LinkedList());
                zones.add(action.getInvolvedEffect());
                break;
            }
            case REMOVE: {
                if (!this.clientActiveFreezeZones.containsKey(type)) break;
                this.clientActiveFreezeZones.get(type).remove(action.getInvolvedEffect());
                break;
            }
            case CLEAR: {
                this.clientActiveFreezeZones.remove(type);
                break;
            }
        }
    }

    @Override
    public void clear(DimensionType dimType) {
        this.clientActiveFreezeZones.remove(dimType);
    }

    @Override
    public void clearClient() {
        this.clientActiveFreezeZones.clear();
    }

    public static class Reader
    extends ClientDataReader<ClientTimeFreezeEffects> {
        @Override
        public void readFromIncomingFullSync(ClientTimeFreezeEffects data, CompoundNBT compound) {
            data.clientActiveFreezeZones.clear();
            CompoundNBT dimTag = compound.func_74775_l("dimTypes");
            for (String dimKey : dimTag.func_150296_c()) {
                DimensionType dimType = DimensionManager.getRegistry().func_218349_b(new ResourceLocation(dimKey)).orElse(null);
                if (dimType == null) continue;
                LinkedList<TimeStopEffectHelper> effects = new LinkedList<TimeStopEffectHelper>();
                ListNBT listEffects = dimTag.func_150295_c(dimKey, 10);
                for (INBT iNBT : listEffects) {
                    effects.add(TimeStopEffectHelper.deserializeNBT((CompoundNBT)iNBT));
                }
                data.clientActiveFreezeZones.put(dimType, effects);
            }
        }

        @Override
        public void readFromIncomingDiff(ClientTimeFreezeEffects data, CompoundNBT compound) {
            ListNBT changes = compound.func_150295_c("changes", 10);
            for (INBT iNBT : changes) {
                DataTimeFreezeEffects.ServerSyncAction action = DataTimeFreezeEffects.ServerSyncAction.deserializeNBT((CompoundNBT)iNBT);
                if (action == null) continue;
                data.applyChange(action);
            }
        }
    }
}

