/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.sync.server;

import hellfirepvp.astralsorcery.common.data.sync.base.AbstractData;
import hellfirepvp.astralsorcery.common.data.sync.base.AbstractDataProvider;
import hellfirepvp.astralsorcery.common.data.sync.base.ClientDataReader;
import hellfirepvp.astralsorcery.common.data.sync.client.ClientLightBlockEndpoints;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.dimension.DimensionType;

public class DataLightBlockEndpoints
extends AbstractData {
    private final Map<DimensionType, Set<BlockPos>> serverPositions = new HashMap<DimensionType, Set<BlockPos>>();
    private final Map<DimensionType, Map<BlockPos, Boolean>> serverChangeBuffer = new HashMap<DimensionType, Map<BlockPos, Boolean>>();
    private final Set<DimensionType> dimensionClearBuffer = new HashSet<DimensionType>();

    private DataLightBlockEndpoints(ResourceLocation key) {
        super(key);
    }

    public void updateNewEndpoint(DimensionType dimType, BlockPos pos) {
        Map posMap = this.serverChangeBuffer.computeIfAbsent(dimType, k -> new HashMap());
        posMap.put(pos, true);
        Set posBuffer = this.serverPositions.computeIfAbsent(dimType, k -> new HashSet());
        posBuffer.add(pos);
        this.markDirty();
    }

    public void updateNewEndpoints(DimensionType dimType, Collection<BlockPos> newPositions) {
        Map posMap = this.serverChangeBuffer.computeIfAbsent(dimType, k -> new HashMap());
        for (BlockPos pos : newPositions) {
            posMap.put(pos, true);
        }
        Set posBuffer = this.serverPositions.computeIfAbsent(dimType, k -> new HashSet());
        posBuffer.addAll(newPositions);
        this.markDirty();
    }

    public void removeEndpoints(DimensionType dimType, Collection<BlockPos> positions) {
        Map posMap = this.serverChangeBuffer.computeIfAbsent(dimType, k -> new HashMap());
        for (BlockPos pos : positions) {
            posMap.put(pos, false);
        }
        Set posBuffer = this.serverPositions.computeIfAbsent(dimType, k -> new HashSet());
        if (posBuffer.removeAll(positions)) {
            this.markDirty();
        }
    }

    public boolean doesPositionReceiveStarlightServer(IWorld world, BlockPos pos) {
        int dim = world.func_201675_m().func_186058_p().func_186068_a();
        return this.serverPositions.getOrDefault(dim, Collections.emptySet()).contains(pos);
    }

    @Override
    public void clear(DimensionType dimType) {
        if (this.serverPositions.remove(dimType) != null) {
            this.serverChangeBuffer.remove(dimType);
            this.dimensionClearBuffer.add(dimType);
            this.markDirty();
        }
    }

    @Override
    public void clearServer() {
        this.dimensionClearBuffer.clear();
        this.serverChangeBuffer.clear();
        this.serverPositions.clear();
    }

    @Override
    public void writeAllDataToPacket(CompoundNBT compound) {
        for (DimensionType dimType : this.serverPositions.keySet()) {
            Set<BlockPos> dat = this.serverPositions.get(dimType);
            ListNBT dataList = new ListNBT();
            for (BlockPos pos : dat) {
                CompoundNBT cmp = new CompoundNBT();
                cmp.func_74772_a("pos", pos.func_218275_a());
                dataList.add((Object)cmp);
            }
            compound.func_218657_a(dimType.getRegistryName().toString(), (INBT)dataList);
        }
    }

    @Override
    public void writeDiffDataToPacket(CompoundNBT compound) {
        ListNBT clearList = new ListNBT();
        for (DimensionType dimType : this.dimensionClearBuffer) {
            clearList.add((Object)StringNBT.func_229705_a_((String)dimType.getRegistryName().toString()));
        }
        compound.func_218657_a("clear", (INBT)clearList);
        for (DimensionType dimType : this.serverChangeBuffer.keySet()) {
            if (this.dimensionClearBuffer.contains(dimType)) continue;
            Map<BlockPos, Boolean> data = this.serverChangeBuffer.get(dimType);
            ListNBT dataList = new ListNBT();
            for (BlockPos pos : data.keySet()) {
                CompoundNBT cmp = new CompoundNBT();
                cmp.func_74772_a("pos", pos.func_218275_a());
                cmp.func_74757_a("add", data.get(pos).booleanValue());
                dataList.add((Object)cmp);
            }
            compound.func_218657_a(dimType.getRegistryName().toString(), (INBT)dataList);
        }
        this.dimensionClearBuffer.clear();
        this.serverChangeBuffer.clear();
    }

    public static class Provider
    extends AbstractDataProvider<DataLightBlockEndpoints, ClientLightBlockEndpoints> {
        public Provider(ResourceLocation key) {
            super(key);
        }

        @Override
        public DataLightBlockEndpoints provideServerData() {
            return new DataLightBlockEndpoints(this.getKey());
        }

        @Override
        public ClientLightBlockEndpoints provideClientData() {
            return new ClientLightBlockEndpoints();
        }

        @Override
        public ClientDataReader<ClientLightBlockEndpoints> createReader() {
            return new ClientLightBlockEndpoints.Reader();
        }
    }
}

