/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.sync.server;

import hellfirepvp.astralsorcery.common.data.sync.base.AbstractData;
import hellfirepvp.astralsorcery.common.data.sync.base.AbstractDataProvider;
import hellfirepvp.astralsorcery.common.data.sync.base.ClientDataReader;
import hellfirepvp.astralsorcery.common.data.sync.client.ClientTimeFreezeEffects;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.time.TimeStopEffectHelper;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.DimensionManager;

public class DataTimeFreezeEffects
extends AbstractData {
    private final Map<DimensionType, List<TimeStopEffectHelper>> serverActiveFreezeZones = new HashMap<DimensionType, List<TimeStopEffectHelper>>();
    private final List<ServerSyncAction> scheduledServerSyncChanges = new LinkedList<ServerSyncAction>();

    private DataTimeFreezeEffects(ResourceLocation key) {
        super(key);
    }

    public void addNewEffect(DimensionType dimType, TimeStopEffectHelper effectHelper) {
        List zones = this.serverActiveFreezeZones.computeIfAbsent(dimType, id -> new LinkedList());
        zones.add(effectHelper);
        this.scheduledServerSyncChanges.add(new ServerSyncAction(ServerSyncAction.ActionType.ADD, dimType, effectHelper));
        this.markDirty();
    }

    public void removeEffect(DimensionType dimType, TimeStopEffectHelper effectHelper) {
        if (this.serverActiveFreezeZones.containsKey(dimType)) {
            this.serverActiveFreezeZones.get(dimType).remove(effectHelper);
        }
        this.scheduledServerSyncChanges.add(new ServerSyncAction(ServerSyncAction.ActionType.REMOVE, dimType, effectHelper));
        this.markDirty();
    }

    @Override
    public void clear(DimensionType dimType) {
        this.serverActiveFreezeZones.remove(dimType);
    }

    @Override
    public void clearServer() {
        this.serverActiveFreezeZones.clear();
        this.scheduledServerSyncChanges.clear();
    }

    @Override
    public void writeAllDataToPacket(CompoundNBT compound) {
        CompoundNBT dimTag = new CompoundNBT();
        for (DimensionType type : this.serverActiveFreezeZones.keySet()) {
            ListNBT tagList = new ListNBT();
            for (TimeStopEffectHelper effect : this.serverActiveFreezeZones.get(type)) {
                tagList.add((Object)effect.serializeNBT());
            }
            dimTag.func_218657_a(type.getRegistryName().toString(), (INBT)tagList);
        }
        compound.func_218657_a("dimTypes", (INBT)dimTag);
    }

    @Override
    public void writeDiffDataToPacket(CompoundNBT compound) {
        ListNBT changes = new ListNBT();
        for (ServerSyncAction action : this.scheduledServerSyncChanges) {
            changes.add((Object)action.serializeNBT());
        }
        compound.func_218657_a("changes", (INBT)changes);
        this.scheduledServerSyncChanges.clear();
    }

    public static class Provider
    extends AbstractDataProvider<DataTimeFreezeEffects, ClientTimeFreezeEffects> {
        public Provider(ResourceLocation key) {
            super(key);
        }

        @Override
        public DataTimeFreezeEffects provideServerData() {
            return new DataTimeFreezeEffects(this.getKey());
        }

        @Override
        public ClientTimeFreezeEffects provideClientData() {
            return new ClientTimeFreezeEffects();
        }

        @Override
        public ClientDataReader<ClientTimeFreezeEffects> createReader() {
            return new ClientTimeFreezeEffects.Reader();
        }
    }

    public static class ServerSyncAction {
        private final ActionType type;
        private final DimensionType dimType;
        private final TimeStopEffectHelper involvedEffect;

        private ServerSyncAction(ActionType type, DimensionType dimType, TimeStopEffectHelper involvedEffect) {
            this.type = type;
            this.dimType = dimType;
            this.involvedEffect = involvedEffect;
        }

        private CompoundNBT serializeNBT() {
            CompoundNBT out = new CompoundNBT();
            out.func_74768_a("type", this.type.ordinal());
            out.func_74778_a("dimType", this.dimType.getRegistryName().toString());
            switch (this.type) {
                case ADD: 
                case REMOVE: {
                    out.func_218657_a("effectTag", (INBT)this.involvedEffect.serializeNBT());
                }
            }
            return out;
        }

        @Nullable
        public static ServerSyncAction deserializeNBT(CompoundNBT cmp) {
            ActionType type = MiscUtils.getEnumEntry(ActionType.class, cmp.func_74762_e("type"));
            String dimTypeKey = cmp.func_74779_i("dimType");
            DimensionType dimType = DimensionManager.getRegistry().func_218349_b(new ResourceLocation(dimTypeKey)).orElse(null);
            if (dimType == null) {
                return null;
            }
            TimeStopEffectHelper helper = null;
            switch (type) {
                case ADD: 
                case REMOVE: {
                    helper = TimeStopEffectHelper.deserializeNBT(cmp.func_74775_l("effectTag"));
                }
            }
            return new ServerSyncAction(type, dimType, helper);
        }

        @Nullable
        public TimeStopEffectHelper getInvolvedEffect() {
            return this.involvedEffect;
        }

        public DimensionType getDimType() {
            return this.dimType;
        }

        public ActionType getType() {
            return this.type;
        }

        public static enum ActionType {
            ADD,
            REMOVE,
            CLEAR;

        }
    }
}

