/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.sync.server;

import hellfirepvp.astralsorcery.common.data.sync.base.AbstractData;
import hellfirepvp.astralsorcery.common.data.sync.base.AbstractDataProvider;
import hellfirepvp.astralsorcery.common.data.sync.base.ClientDataReader;
import hellfirepvp.astralsorcery.common.data.sync.client.ClientTimeFreezeEntities;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.dimension.DimensionType;

public class DataTimeFreezeEntities
extends AbstractData {
    private final Map<DimensionType, Set<Integer>> serverActiveEntityFreeze = new HashMap<DimensionType, Set<Integer>>();
    private final Set<DimensionType> serverSyncTypes = new HashSet<DimensionType>();

    private DataTimeFreezeEntities(ResourceLocation key) {
        super(key);
    }

    public void freezeEntity(Entity e) {
        if (this.serverActiveEntityFreeze.computeIfAbsent(e.field_71093_bK, dimType -> new HashSet()).add(e.func_145782_y())) {
            this.serverSyncTypes.add(e.field_71093_bK);
            this.markDirty();
        }
    }

    public void unfreezeEntity(Entity e) {
        if (this.serverActiveEntityFreeze.getOrDefault(e.field_71093_bK, Collections.emptySet()).remove(e.func_145782_y())) {
            this.serverSyncTypes.add(e.field_71093_bK);
            this.markDirty();
        }
    }

    public boolean isFrozen(Entity e) {
        return this.serverActiveEntityFreeze.getOrDefault(e.field_71093_bK, Collections.emptySet()).contains(e.func_145782_y());
    }

    @Override
    public void clear(DimensionType dimType) {
        this.serverActiveEntityFreeze.remove(dimType);
    }

    @Override
    public void clearServer() {
        this.serverActiveEntityFreeze.clear();
        this.serverSyncTypes.clear();
    }

    @Override
    public void writeAllDataToPacket(CompoundNBT compound) {
        this.writeEntityInformation(compound, this.serverActiveEntityFreeze);
    }

    @Override
    public void writeDiffDataToPacket(CompoundNBT compound) {
        HashMap<DimensionType, Set<Integer>> entities = new HashMap<DimensionType, Set<Integer>>();
        this.serverSyncTypes.forEach(type -> entities.put((DimensionType)type, this.serverActiveEntityFreeze.getOrDefault(type, new HashSet())));
        this.writeEntityInformation(compound, entities);
        this.serverSyncTypes.clear();
    }

    private void writeEntityInformation(CompoundNBT out, Map<DimensionType, Set<Integer>> entities) {
        CompoundNBT dimTag = new CompoundNBT();
        entities.forEach((dimType, entityIds) -> {
            ListNBT nbtEntities = new ListNBT();
            entityIds.forEach(id -> nbtEntities.add((Object)IntNBT.func_229692_a_((int)id)));
            dimTag.func_218657_a(dimType.getRegistryName().toString(), (INBT)nbtEntities);
        });
        out.func_218657_a("dimTypes", (INBT)dimTag);
    }

    public static class Provider
    extends AbstractDataProvider<DataTimeFreezeEntities, ClientTimeFreezeEntities> {
        public Provider(ResourceLocation key) {
            super(key);
        }

        @Override
        public DataTimeFreezeEntities provideServerData() {
            return new DataTimeFreezeEntities(this.getKey());
        }

        @Override
        public ClientTimeFreezeEntities provideClientData() {
            return new ClientTimeFreezeEntities();
        }

        @Override
        public ClientDataReader<ClientTimeFreezeEntities> createReader() {
            return new ClientTimeFreezeEntities.Reader();
        }
    }
}

