/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.world;

import hellfirepvp.astralsorcery.common.auxiliary.gateway.CelestialGatewayHandler;
import hellfirepvp.astralsorcery.common.tile.TileCelestialGateway;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.PlayerReference;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import hellfirepvp.astralsorcery.common.util.log.LogCategory;
import hellfirepvp.astralsorcery.common.util.log.LogUtil;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import hellfirepvp.observerlib.common.data.WorldCacheDomain;
import hellfirepvp.observerlib.common.data.base.GlobalWorldData;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class GatewayCache
extends GlobalWorldData {
    private final Set<GatewayNode> gatewayPositions = new HashSet<GatewayNode>();

    public GatewayCache(WorldCacheDomain.SaveKey<?> key) {
        super(key);
    }

    public Collection<GatewayNode> getGatewayPositions() {
        return Collections.unmodifiableCollection(this.gatewayPositions);
    }

    public boolean hasGateway(BlockPos pos) {
        return this.gatewayPositions.stream().anyMatch(gateway -> gateway.getPos().equals((Object)pos));
    }

    @Nullable
    public GatewayNode getGatewayNode(BlockPos pos) {
        return this.gatewayPositions.stream().filter(gateway -> gateway.getPos().equals((Object)pos)).findFirst().orElse(null);
    }

    public void updateGatewayNode(BlockPos pos, Consumer<GatewayNodeAccess> nodeFn) {
        this.gatewayPositions.stream().filter(gateway -> gateway.getPos().equals((Object)pos)).findFirst().ifPresent(gatewayNode -> this.update((GatewayNode)gatewayNode, nodeFn));
    }

    private void update(GatewayNode node, Consumer<GatewayNodeAccess> nodeFn) {
        nodeFn.accept(node.writeAccess());
        this.markDirty();
        CelestialGatewayHandler.INSTANCE.syncToAll();
    }

    public boolean offerPosition(World world, BlockPos pos) {
        TileCelestialGateway te = MiscUtils.getTileAt((IBlockReader)world, pos, TileCelestialGateway.class, false);
        if (te == null) {
            return false;
        }
        GatewayNode node = new GatewayNode(pos);
        if (!this.gatewayPositions.add(node)) {
            return false;
        }
        this.markDirty();
        CelestialGatewayHandler.INSTANCE.addPosition((IWorld)world, node);
        LogUtil.info(LogCategory.GATEWAY_CACHE, () -> "Added new gateway node at: dim=" + world.func_201675_m().func_186058_p().func_186068_a() + ", " + pos.toString());
        return true;
    }

    public void removePosition(World world, BlockPos pos) {
        if (this.gatewayPositions.removeIf(node -> node.getPos().equals((Object)pos))) {
            this.markDirty();
            CelestialGatewayHandler.INSTANCE.removePosition((IWorld)world, pos);
            LogUtil.info(LogCategory.GATEWAY_CACHE, () -> "Removed gateway node at: dim=" + world.func_201675_m().func_186058_p().func_186068_a() + ", " + pos.toString());
        }
    }

    public void updateTick(World world) {
    }

    public void onLoad(IWorld world) {
        super.onLoad(world);
        LogUtil.info(LogCategory.GATEWAY_CACHE, () -> "Checking GatewayCache integrity for dimension " + world.func_201675_m().func_186058_p().func_186068_a());
        long msStart = System.currentTimeMillis();
        Iterator<GatewayNode> iterator = this.gatewayPositions.iterator();
        while (iterator.hasNext()) {
            TileCelestialGateway gateway;
            GatewayNode node = iterator.next();
            try {
                gateway = MiscUtils.getTileAt((IBlockReader)world, node.getPos(), TileCelestialGateway.class, true);
            }
            catch (Exception loadEx) {
                LogUtil.info(LogCategory.GATEWAY_CACHE, () -> "Failed to check gateway for " + node + " skipping");
                continue;
            }
            if (gateway != null) continue;
            iterator.remove();
            LogUtil.info(LogCategory.GATEWAY_CACHE, () -> "Invalid entry: " + node + " - no gateway tileentity found there!");
        }
        LogUtil.info(LogCategory.GATEWAY_CACHE, () -> "GatewayCache checked and fully loaded in " + (System.currentTimeMillis() - msStart) + "ms! Collected and checked " + this.gatewayPositions.size() + " gateway nodes!");
    }

    public void writeToNBT(CompoundNBT compound) {
        ListNBT list = new ListNBT();
        for (GatewayNode node : this.gatewayPositions) {
            CompoundNBT tag = new CompoundNBT();
            node.write(tag);
            list.add((Object)tag);
        }
        compound.func_218657_a("posList", (INBT)list);
    }

    public void readFromNBT(CompoundNBT compound) {
        ListNBT list = compound.func_150295_c("posList", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT tag = list.func_150305_b(i);
            this.gatewayPositions.add(GatewayNode.read(tag));
        }
    }

    public static class GatewayNodeAccess
    extends GatewayNode {
        private final GatewayNode decorated;

        public GatewayNodeAccess(GatewayNode decorated) {
            super(decorated.getPos());
            this.decorated = decorated;
        }

        @Override
        @Nullable
        public DyeColor getColor() {
            return this.decorated.getColor();
        }

        public void setColor(@Nullable DyeColor color) {
            this.decorated.color = color;
        }

        @Override
        @Nullable
        public ITextComponent getDisplayName() {
            return this.decorated.getDisplayName();
        }

        public void setDisplayName(@Nullable ITextComponent displayName) {
            this.decorated.display = displayName;
        }

        @Override
        public boolean isLocked() {
            return this.decorated.isLocked();
        }

        public void setLocked(boolean locked) {
            this.decorated.locked = locked;
        }

        @Override
        @Nullable
        public PlayerReference getOwner() {
            return this.decorated.getOwner();
        }

        public void setOwner(PlayerReference owner) {
            this.decorated.owner = owner;
        }

        @Override
        public Map<Integer, PlayerReference> getAllowedUsers() {
            return this.decorated.getAllowedUsers();
        }

        public void setAllowedUsers(Map<Integer, PlayerReference> users) {
            this.decorated.allowedUsers.clear();
            this.decorated.allowedUsers.putAll(users);
        }
    }

    public static class GatewayNode {
        private final BlockPos pos;
        private ITextComponent display;
        private DyeColor color;
        private boolean locked = false;
        private PlayerReference owner = null;
        private Map<Integer, PlayerReference> allowedUsers = new HashMap<Integer, PlayerReference>();

        private GatewayNode(BlockPos pos) {
            this.pos = pos;
        }

        private GatewayNodeAccess writeAccess() {
            return new GatewayNodeAccess(this);
        }

        @Nonnull
        public final BlockPos getPos() {
            return this.pos;
        }

        @Nullable
        public ITextComponent getDisplayName() {
            return this.display;
        }

        @Nullable
        public DyeColor getColor() {
            return this.color;
        }

        public boolean isLocked() {
            return this.locked;
        }

        @Nullable
        public PlayerReference getOwner() {
            return this.owner;
        }

        public Map<Integer, PlayerReference> getAllowedUsers() {
            return Collections.unmodifiableMap(this.allowedUsers);
        }

        public boolean hasAccess(PlayerEntity player) {
            PlayerReference owner = this.getOwner();
            if (owner == null || !this.isLocked()) {
                return true;
            }
            return owner.isPlayer(player) || this.getAllowedUsers().values().stream().anyMatch(ref -> ref.isPlayer(player));
        }

        public void write(CompoundNBT tag) {
            NBTHelper.writeBlockPosToNBT(this.getPos(), tag);
            if (this.getDisplayName() != null) {
                tag.func_74778_a("display", ITextComponent.Serializer.func_150696_a((ITextComponent)this.getDisplayName()));
            }
            if (this.getColor() != null) {
                NBTHelper.writeEnum(tag, "color", this.getColor());
            }
            tag.func_74757_a("locked", this.isLocked());
            NBTHelper.writeOptional(tag, "owningPlayer", this.getOwner(), (compound, playerRef) -> playerRef.writeToNBT((CompoundNBT)compound));
            NBTHelper.writeList(tag, "allowedUsers", this.allowedUsers.entrySet(), entry -> {
                CompoundNBT compound = new CompoundNBT();
                compound.func_74768_a("index", ((Integer)entry.getKey()).intValue());
                compound.func_218657_a("player", (INBT)((PlayerReference)entry.getValue()).serialize());
                return compound;
            });
        }

        public void write(PacketBuffer buf) {
            ByteBufUtils.writePos(buf, this.getPos());
            ByteBufUtils.writeOptional(buf, this.getDisplayName(), ByteBufUtils::writeTextComponent);
            ByteBufUtils.writeOptional(buf, this.getColor(), ByteBufUtils::writeEnumValue);
            buf.writeBoolean(this.isLocked());
            ByteBufUtils.writeOptional(buf, this.getOwner(), (buffer, ref) -> ref.write((PacketBuffer)buffer));
            ByteBufUtils.writeMap(buf, this.getAllowedUsers(), PacketBuffer::writeInt, (buffer, ref) -> ref.write((PacketBuffer)buffer));
        }

        public static GatewayNode read(CompoundNBT tag) {
            GatewayNode node = new GatewayNode(NBTHelper.readBlockPosFromNBT(tag));
            if (tag.func_74764_b("display")) {
                node.display = ITextComponent.Serializer.func_150699_a((String)tag.func_74779_i("display"));
            }
            if (tag.func_74764_b("color")) {
                node.color = NBTHelper.readEnum(tag, "color", DyeColor.class);
            }
            node.locked = tag.func_74767_n("locked");
            node.owner = NBTHelper.readOptional(tag, "owningPlayer", PlayerReference::deserialize);
            NBTHelper.readList(tag, "allowedUsers", 10, nbt -> {
                CompoundNBT compound = (CompoundNBT)nbt;
                return new Tuple((Object)compound.func_74762_e("index"), (Object)PlayerReference.deserialize(compound.func_74775_l("player")));
            }).forEach(tpl -> node.allowedUsers.put((Integer)tpl.func_76341_a(), (PlayerReference)tpl.func_76340_b()));
            return node;
        }

        public static GatewayNode read(PacketBuffer buf) {
            GatewayNode node = new GatewayNode(ByteBufUtils.readPos(buf));
            node.display = ByteBufUtils.readOptional(buf, ByteBufUtils::readTextComponent);
            node.color = ByteBufUtils.readOptional(buf, buffer -> ByteBufUtils.readEnumValue(buffer, DyeColor.class));
            node.locked = buf.readBoolean();
            node.owner = ByteBufUtils.readOptional(buf, PlayerReference::read);
            node.allowedUsers = ByteBufUtils.readMap(buf, PacketBuffer::readInt, PlayerReference::read);
            return node;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GatewayNode that = (GatewayNode)o;
            return Objects.equals(this.getPos(), that.getPos());
        }

        public int hashCode() {
            return Objects.hash(this.getPos());
        }
    }
}

