/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.item.gem;

import hellfirepvp.astralsorcery.common.data.config.registry.WeightedPerkAttributeRegistry;
import hellfirepvp.astralsorcery.common.data.config.registry.sets.PerkAttributeEntry;
import hellfirepvp.astralsorcery.common.item.gem.GemType;
import hellfirepvp.astralsorcery.common.item.gem.ItemPerkGem;
import hellfirepvp.astralsorcery.common.perk.DynamicModifierHelper;
import hellfirepvp.astralsorcery.common.perk.modifier.DynamicAttributeModifier;
import hellfirepvp.astralsorcery.common.perk.type.ModifierType;
import hellfirepvp.astralsorcery.common.perk.type.PerkAttributeType;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;

public class GemAttributeHelper {
    private static final Random rand = new Random();
    private static float chance3Modifiers = 0.4f;
    private static float chance4Modifiers = 0.15f;
    private static boolean allowDuplicateTypes = false;
    private static float incModifierLower = 0.05f;
    private static float incModifierHigher = 0.08f;
    private static boolean allowNegativeModifiers = false;
    private static float chanceNegative = 0.25f;
    private static float decModifierLower = -0.05f;
    private static float decModifierHigher = -0.08f;
    private static boolean allowMoreLessModifiers = false;
    private static float chanceMultiplicative = 0.1f;
    private static float moreModifierLower = 0.05f;
    private static float moreModifierHigher = 0.08f;
    private static float lessModifierLower = -0.05f;
    private static float lessModifierHigher = -0.08f;

    public static boolean rollGem(ItemStack gem) {
        return GemAttributeHelper.rollGem(gem, rand);
    }

    public static boolean rollGem(ItemStack gem, Random random) {
        if (!DynamicModifierHelper.getStaticModifiers(gem).isEmpty()) {
            return false;
        }
        GemType gemType = ItemPerkGem.getGemType(gem);
        if (gemType == null) {
            return false;
        }
        int rolls = GemAttributeHelper.getPotentialMods(random, gemType.countModifier);
        ArrayList<DynamicAttributeModifier> mods = new ArrayList<DynamicAttributeModifier>();
        List configuredModifiers = WeightedPerkAttributeRegistry.INSTANCE.getConfiguredValues();
        for (int i = 0; i < rolls; ++i) {
            float value;
            float higher;
            float lower;
            boolean isMultiplicative;
            PerkAttributeEntry entry = null;
            if (allowDuplicateTypes) {
                entry = MiscUtils.getWeightedRandomEntry(configuredModifiers, random, PerkAttributeEntry::getWeight);
            } else {
                ArrayList<PerkAttributeEntry> keys = new ArrayList<PerkAttributeEntry>(configuredModifiers);
                while (!keys.isEmpty() && entry == null) {
                    PerkAttributeEntry item = GemAttributeHelper.getWeightedResultAndRemove(keys, random);
                    if (item == null) continue;
                    boolean foundType = false;
                    for (DynamicAttributeModifier m : mods) {
                        if (!m.getAttributeType().equals((Object)item.getType())) continue;
                        foundType = true;
                        break;
                    }
                    if (foundType) continue;
                    entry = item;
                }
            }
            if (entry == null) continue;
            boolean isNegative = allowNegativeModifiers && random.nextFloat() < chanceNegative;
            boolean bl = isMultiplicative = allowMoreLessModifiers && random.nextFloat() < chanceMultiplicative;
            float f = isNegative ? (isMultiplicative ? lessModifierLower : decModifierLower) : (lower = isMultiplicative ? moreModifierLower : incModifierLower);
            float f2 = isNegative ? (isMultiplicative ? lessModifierHigher : decModifierHigher) : (higher = isMultiplicative ? moreModifierHigher : incModifierHigher);
            if (lower > higher) {
                value = lower;
            } else {
                float exp = 1.0f / gemType.amplifierModifier;
                float multiplierScale = (float)Math.pow(random.nextFloat(), exp);
                value = lower + MathHelper.func_76131_a((float)multiplierScale, (float)0.0f, (float)1.0f) * (higher - lower);
            }
            ModifierType mode = isMultiplicative ? ModifierType.STACKING_MULTIPLY : ModifierType.ADDED_MULTIPLY;
            float rValue = isMultiplicative ? 1.0f + value : value;
            PerkAttributeType type = entry.getType();
            if (allowDuplicateTypes) {
                DynamicAttributeModifier existing = MiscUtils.iterativeSearch(mods, mod -> mod.getAttributeType().equals((Object)type) && mod.getMode().equals((Object)mode));
                if (existing != null) {
                    mods.remove((Object)existing);
                    float combinedValue = isMultiplicative ? existing.getRawValue() - 1.0f + (rValue - 1.0f) : existing.getRawValue() + rValue;
                    if (combinedValue == 0.0f) continue;
                    mods.add(new DynamicAttributeModifier(UUID.randomUUID(), type, mode, isMultiplicative ? combinedValue + 1.0f : combinedValue));
                    continue;
                }
                mods.add(new DynamicAttributeModifier(UUID.randomUUID(), type, mode, rValue));
                continue;
            }
            mods.add(new DynamicAttributeModifier(UUID.randomUUID(), type, mode, rValue));
        }
        DynamicModifierHelper.addModifiers(gem, mods);
        return true;
    }

    @Nullable
    private static PerkAttributeEntry getWeightedResultAndRemove(List<PerkAttributeEntry> list, Random random) {
        if (list.isEmpty()) {
            return null;
        }
        PerkAttributeEntry result = MiscUtils.getWeightedRandomEntry(list, random, PerkAttributeEntry::getWeight);
        if (result != null) {
            list.remove(result);
        }
        return result;
    }

    private static int getPotentialMods(Random random, float countModifier) {
        int mods = 2;
        if (random.nextFloat() < chance3Modifiers + countModifier) {
            ++mods;
            if (random.nextFloat() < chance4Modifiers + countModifier) {
                ++mods;
            }
        }
        return mods;
    }
}

