/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.item.tool;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import hellfirepvp.astralsorcery.common.CommonProxy;
import hellfirepvp.astralsorcery.common.crystal.CalculationContext;
import hellfirepvp.astralsorcery.common.crystal.CrystalAttributeItem;
import hellfirepvp.astralsorcery.common.crystal.CrystalAttributes;
import hellfirepvp.astralsorcery.common.crystal.CrystalCalculations;
import hellfirepvp.astralsorcery.common.item.tool.CrystalToolTier;
import hellfirepvp.astralsorcery.common.lib.CrystalPropertiesAS;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;

public abstract class ItemCrystalTierItem
extends Item
implements CrystalAttributeItem {
    private final Set<Material> effectiveMaterials;
    private final ToolType toolType;

    protected ItemCrystalTierItem(@Nullable ToolType toolType, Item.Properties prop, Set<Material> effectiveMaterials) {
        super(ItemCrystalTierItem.withTool(toolType, prop.func_200918_c(CrystalToolTier.getInstance().func_200926_a()).setNoRepair().func_200916_a(CommonProxy.ITEM_GROUP_AS)));
        this.effectiveMaterials = effectiveMaterials;
        this.toolType = toolType;
    }

    private static Item.Properties withTool(@Nullable ToolType tool, Item.Properties prop) {
        if (tool != null) {
            prop.addToolType(tool, CrystalToolTier.getInstance().func_200925_d());
        }
        return prop;
    }

    abstract double getAttackDamage();

    abstract double getAttackSpeed();

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        CrystalAttributes attr = this.getAttributes(stack);
        if (attr != null) {
            attr.addTooltip(tooltip, CalculationContext.Builder.newBuilder().addUsage(CrystalPropertiesAS.Usages.USE_TOOL_DURABILITY).addUsage(CrystalPropertiesAS.Usages.USE_TOOL_EFFECTIVENESS).build());
        }
        super.func_77624_a(stack, world, tooltip, flag);
    }

    public int getMaxDamage(ItemStack stack) {
        CrystalAttributes attr = this.getAttributes(stack);
        if (attr != null) {
            return CrystalCalculations.getToolDurability(super.getMaxDamage(stack), stack);
        }
        return super.getMaxDamage(stack);
    }

    public boolean canHarvestBlock(ItemStack stack, BlockState state) {
        int i = CrystalToolTier.getInstance().func_200925_d();
        if (this.toolType != null && state.getHarvestTool() == this.toolType) {
            return i >= state.getHarvestLevel();
        }
        return this.effectiveMaterials.contains(state.func_185904_a());
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        float str = super.func_150893_a(stack, state);
        if (this.getToolTypes(stack).stream().noneMatch(arg_0 -> ((BlockState)state).isToolEffective(arg_0)) && !this.isToolEfficientAgainst(state) && !this.effectiveMaterials.contains(state.func_185904_a())) {
            return str;
        }
        str *= CrystalToolTier.getInstance().func_200928_b();
        CrystalAttributes attr = this.getAttributes(stack);
        if (attr != null) {
            return CrystalCalculations.getToolEfficiency(str, stack);
        }
        return str;
    }

    protected boolean isToolEfficientAgainst(BlockState state) {
        return false;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.func_222118_a(1, attacker, entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (!worldIn.field_72995_K && state.func_185887_b((IBlockReader)worldIn, pos) != 0.0f) {
            stack.func_222118_a(1, entityLiving, p_220038_0_ -> p_220038_0_.func_213361_c(EquipmentSlotType.MAINHAND));
        }
        return true;
    }

    @Override
    @Nullable
    public CrystalAttributes getAttributes(ItemStack stack) {
        return CrystalAttributes.getCrystalAttributes(stack);
    }

    @Override
    public void setAttributes(ItemStack stack, @Nullable CrystalAttributes attributes) {
        if (attributes != null) {
            attributes.store(stack);
        } else {
            CrystalAttributes.storeNull(stack);
        }
    }

    public boolean isRepairable(ItemStack stack) {
        return false;
    }

    public boolean func_82789_a(ItemStack p_82789_1_, ItemStack p_82789_2_) {
        return false;
    }

    public int getItemEnchantability(ItemStack stack) {
        return CrystalToolTier.getInstance().func_200927_e();
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EquipmentSlotType.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", this.getAttackDamage(), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", this.getAttackSpeed(), AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }
}

