/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.network.login.server;

import hellfirepvp.astralsorcery.common.data.sync.SyncDataHolder;
import hellfirepvp.astralsorcery.common.data.sync.SyncDataRegistry;
import hellfirepvp.astralsorcery.common.data.sync.base.AbstractData;
import hellfirepvp.astralsorcery.common.data.sync.base.ClientData;
import hellfirepvp.astralsorcery.common.data.sync.base.ClientDataReader;
import hellfirepvp.astralsorcery.common.network.base.ASLoginPacket;
import hellfirepvp.astralsorcery.common.network.base.ASPacket;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class PktLoginSyncDataHolder
extends ASLoginPacket<PktLoginSyncDataHolder> {
    private Map<ResourceLocation, CompoundNBT> syncData = new HashMap<ResourceLocation, CompoundNBT>();

    public static PktLoginSyncDataHolder makeLogin() {
        PktLoginSyncDataHolder pkt = new PktLoginSyncDataHolder();
        for (ResourceLocation key : SyncDataRegistry.getKnownKeys()) {
            SyncDataHolder.executeServer(key, AbstractData.class, data -> {
                CompoundNBT nbt = new CompoundNBT();
                data.writeAllDataToPacket(nbt);
                pkt.syncData.put(key, nbt);
            });
        }
        return pkt;
    }

    @Override
    @Nonnull
    public ASPacket.Encoder<PktLoginSyncDataHolder> encoder() {
        return (packet, buffer) -> {
            buffer.writeInt(packet.syncData.size());
            for (ResourceLocation key : packet.syncData.keySet()) {
                ByteBufUtils.writeResourceLocation(buffer, key);
                ByteBufUtils.writeNBTTag(buffer, packet.syncData.get(key));
            }
        };
    }

    @Override
    @Nonnull
    public ASPacket.Decoder<PktLoginSyncDataHolder> decoder() {
        return buffer -> {
            PktLoginSyncDataHolder pktData = new PktLoginSyncDataHolder();
            int size = buffer.readInt();
            for (int i = 0; i < size; ++i) {
                ResourceLocation key = ByteBufUtils.readResourceLocation(buffer);
                CompoundNBT tag = ByteBufUtils.readNBTTag(buffer);
                pktData.syncData.put(key, tag);
            }
            return pktData;
        };
    }

    @Override
    @Nonnull
    public ASPacket.Handler<PktLoginSyncDataHolder> handler() {
        return new ASPacket.Handler<PktLoginSyncDataHolder>(){

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void handleClient(PktLoginSyncDataHolder packet, NetworkEvent.Context context) {
                context.enqueueWork(() -> {
                    for (ResourceLocation key : packet.syncData.keySet()) {
                        ClientDataReader reader = SyncDataHolder.getReader(key);
                        if (reader == null) continue;
                        SyncDataHolder.executeClient(key, ClientData.class, data -> reader.readFromIncomingFullSync(data, (CompoundNBT)packet.syncData.get(key)));
                    }
                    PktLoginSyncDataHolder.this.acknowledge(context);
                });
            }

            @Override
            public void handle(PktLoginSyncDataHolder packet, NetworkEvent.Context context, LogicalSide side) {
            }
        };
    }
}

