/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.network.login.server;

import hellfirepvp.astralsorcery.common.auxiliary.gateway.CelestialGatewayHandler;
import hellfirepvp.astralsorcery.common.data.world.GatewayCache;
import hellfirepvp.astralsorcery.common.network.base.ASLoginPacket;
import hellfirepvp.astralsorcery.common.network.base.ASPacket;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class PktLoginSyncGateway
extends ASLoginPacket<PktLoginSyncGateway> {
    private Map<ResourceLocation, Collection<GatewayCache.GatewayNode>> positions = new HashMap<ResourceLocation, Collection<GatewayCache.GatewayNode>>();

    public static PktLoginSyncGateway makeLogin() {
        PktLoginSyncGateway pkt = new PktLoginSyncGateway();
        pkt.positions = CelestialGatewayHandler.INSTANCE.getGatewayCache(LogicalSide.SERVER);
        return pkt;
    }

    @Override
    @Nonnull
    public ASPacket.Encoder<PktLoginSyncGateway> encoder() {
        return (packet, buffer) -> {
            buffer.writeInt(packet.positions.size());
            for (ResourceLocation dim : packet.positions.keySet()) {
                ByteBufUtils.writeResourceLocation(buffer, dim);
                ByteBufUtils.writeCollection(buffer, packet.positions.get(dim), (buf, node) -> node.write((PacketBuffer)buf));
            }
        };
    }

    @Override
    @Nonnull
    public ASPacket.Decoder<PktLoginSyncGateway> decoder() {
        return buffer -> {
            PktLoginSyncGateway pkt = new PktLoginSyncGateway();
            int dimSize = buffer.readInt();
            for (int i = 0; i < dimSize; ++i) {
                ResourceLocation dim = ByteBufUtils.readResourceLocation(buffer);
                pkt.positions.put(dim, ByteBufUtils.readList(buffer, GatewayCache.GatewayNode::read));
            }
            return pkt;
        };
    }

    @Override
    @Nonnull
    public ASPacket.Handler<PktLoginSyncGateway> handler() {
        return new ASPacket.Handler<PktLoginSyncGateway>(){

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void handleClient(PktLoginSyncGateway packet, NetworkEvent.Context context) {
                context.enqueueWork(() -> {
                    CelestialGatewayHandler.INSTANCE.updateClientCache(packet.positions);
                    PktLoginSyncGateway.this.acknowledge(context);
                });
            }

            @Override
            public void handle(PktLoginSyncGateway packet, NetworkEvent.Context context, LogicalSide side) {
            }
        };
    }
}

