/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.network.play.client;

import hellfirepvp.astralsorcery.common.constellation.DrawnConstellation;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.network.base.ASPacket;
import hellfirepvp.astralsorcery.common.tile.TileRefractionTable;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import java.awt.Point;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;

public class PktEngraveGlass
extends ASPacket<PktEngraveGlass> {
    private DimensionType type;
    private BlockPos pos;
    private List<DrawnConstellation> constellations = new LinkedList<DrawnConstellation>();

    public PktEngraveGlass() {
    }

    public PktEngraveGlass(DimensionType type, BlockPos pos, List<DrawnConstellation> constellations) {
        this.type = type;
        this.pos = pos;
        this.constellations = constellations;
    }

    @Override
    @Nonnull
    public ASPacket.Encoder<PktEngraveGlass> encoder() {
        return (packet, buffer) -> {
            ByteBufUtils.writeRegistryEntry(buffer, packet.type);
            ByteBufUtils.writePos(buffer, packet.pos);
            ByteBufUtils.writeCollection(buffer, packet.constellations, (buf, cst) -> {
                buf.writeInt(cst.getPoint().x);
                buf.writeInt(cst.getPoint().y);
                ByteBufUtils.writeRegistryEntry(buf, cst.getConstellation());
            });
        };
    }

    @Override
    @Nonnull
    public ASPacket.Decoder<PktEngraveGlass> decoder() {
        return buffer -> {
            PktEngraveGlass pkt = new PktEngraveGlass();
            pkt.type = (DimensionType)ByteBufUtils.readRegistryEntry(buffer);
            pkt.pos = ByteBufUtils.readPos(buffer);
            pkt.constellations = ByteBufUtils.readList(buffer, buf -> new DrawnConstellation(new Point(buf.readInt(), buf.readInt()), (IConstellation)ByteBufUtils.readRegistryEntry(buf)));
            return pkt;
        };
    }

    @Override
    @Nonnull
    public ASPacket.Handler<PktEngraveGlass> handler() {
        return (packet, context, side) -> context.enqueueWork(() -> {
            MinecraftServer srv = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
            ServerWorld world = srv.func_71218_a(packet.type);
            TileRefractionTable tmt = MiscUtils.getTileAt((IBlockReader)world, packet.pos, TileRefractionTable.class, false);
            if (tmt != null && !packet.constellations.isEmpty()) {
                List<DrawnConstellation> cstList = packet.constellations.subList(0, Math.min(3, packet.constellations.size()));
                tmt.engraveGlass(cstList);
            }
        });
    }
}

