/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.network.play.client;

import hellfirepvp.astralsorcery.common.network.base.ASPacket;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import hellfirepvp.astralsorcery.common.util.world.WorldSeedCache;
import javax.annotation.Nonnull;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.IWorld;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.network.NetworkEvent;

public class PktRequestSeed
extends ASPacket<PktRequestSeed> {
    private DimensionType type;
    private Integer session;
    private Long seed;

    public PktRequestSeed() {
    }

    public PktRequestSeed(Integer session, DimensionType type) {
        this.type = type;
        this.session = session;
        this.seed = -1L;
    }

    private PktRequestSeed seed(Long seed) {
        this.seed = seed;
        return this;
    }

    @Override
    @Nonnull
    public ASPacket.Encoder<PktRequestSeed> encoder() {
        return (packet, buffer) -> {
            ByteBufUtils.writeOptional(buffer, packet.type, ByteBufUtils::writeRegistryEntry);
            ByteBufUtils.writeOptional(buffer, packet.session, PacketBuffer::writeInt);
            ByteBufUtils.writeOptional(buffer, packet.seed, PacketBuffer::writeLong);
        };
    }

    @Override
    @Nonnull
    public ASPacket.Decoder<PktRequestSeed> decoder() {
        return buffer -> {
            PktRequestSeed pkt = new PktRequestSeed();
            pkt.type = ByteBufUtils.readOptional(buffer, ByteBufUtils::readRegistryEntry);
            pkt.session = ByteBufUtils.readOptional(buffer, PacketBuffer::readInt);
            pkt.seed = ByteBufUtils.readOptional(buffer, PacketBuffer::readLong);
            return pkt;
        };
    }

    @Override
    @Nonnull
    public ASPacket.Handler<PktRequestSeed> handler() {
        return new ASPacket.Handler<PktRequestSeed>(){

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void handleClient(PktRequestSeed packet, NetworkEvent.Context context) {
                context.enqueueWork(() -> WorldSeedCache.updateSeedCache(packet.type, packet.session, packet.seed));
            }

            @Override
            public void handle(PktRequestSeed packet, NetworkEvent.Context context, LogicalSide side) {
                context.enqueueWork(() -> {
                    MinecraftServer srv = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
                    ServerWorld w = srv.func_71218_a(packet.type);
                    PktRequestSeed seedResponse = new PktRequestSeed(packet.session, packet.type);
                    seedResponse.seed(MiscUtils.getRandomWorldSeed((IWorld)w));
                    packet.replyWith(seedResponse, context);
                });
            }
        };
    }
}

