/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.network.play.client;

import hellfirepvp.astralsorcery.client.screen.ScreenTelescope;
import hellfirepvp.astralsorcery.common.network.base.ASPacket;
import hellfirepvp.astralsorcery.common.tile.TileTelescope;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.network.NetworkEvent;

public class PktRotateTelescope
extends ASPacket<PktRotateTelescope> {
    private boolean isClockwise = false;
    private DimensionType type = null;
    private BlockPos pos = BlockPos.field_177992_a;

    public PktRotateTelescope() {
    }

    public PktRotateTelescope(boolean isClockwise, DimensionType type, BlockPos pos) {
        this.isClockwise = isClockwise;
        this.type = type;
        this.pos = pos;
    }

    @Override
    @Nonnull
    public ASPacket.Encoder<PktRotateTelescope> encoder() {
        return (packet, buffer) -> {
            buffer.writeBoolean(packet.isClockwise);
            ByteBufUtils.writeOptional(buffer, packet.type, ByteBufUtils::writeRegistryEntry);
            ByteBufUtils.writePos(buffer, packet.pos);
        };
    }

    @Override
    @Nonnull
    public ASPacket.Decoder<PktRotateTelescope> decoder() {
        return buffer -> {
            PktRotateTelescope pkt = new PktRotateTelescope();
            pkt.isClockwise = buffer.readBoolean();
            pkt.type = ByteBufUtils.readOptional(buffer, ByteBufUtils::readRegistryEntry);
            pkt.pos = ByteBufUtils.readPos(buffer);
            return pkt;
        };
    }

    @Override
    @Nonnull
    public ASPacket.Handler<PktRotateTelescope> handler() {
        return new ASPacket.Handler<PktRotateTelescope>(){

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void handleClient(PktRotateTelescope packet, NetworkEvent.Context context) {
                context.enqueueWork(() -> {
                    Optional clWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(LogicalSide.CLIENT);
                    clWorld.ifPresent(world -> {
                        TileTelescope tt = MiscUtils.getTileAt((IBlockReader)world, packet.pos, TileTelescope.class, false);
                        if (tt != null) {
                            tt.setRotation(packet.isClockwise ? tt.getRotation().nextClockWise() : tt.getRotation().nextCounterClockWise());
                        }
                    });
                    if (Minecraft.func_71410_x().field_71462_r instanceof ScreenTelescope) {
                        ((ScreenTelescope)Minecraft.func_71410_x().field_71462_r).handleRotationChange(packet.isClockwise);
                    }
                });
            }

            @Override
            public void handle(PktRotateTelescope packet, NetworkEvent.Context context, LogicalSide side) {
                context.enqueueWork(() -> {
                    MinecraftServer srv = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
                    ServerWorld world = srv.func_71218_a(packet.type);
                    TileTelescope tt = MiscUtils.getTileAt((IBlockReader)world, packet.pos, TileTelescope.class, false);
                    if (tt != null) {
                        tt.setRotation(packet.isClockwise ? tt.getRotation().nextClockWise() : tt.getRotation().nextCounterClockWise());
                        packet.replyWith(new PktRotateTelescope(packet.isClockwise, packet.type, packet.pos), context);
                    }
                });
            }
        };
    }
}

