/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.network.play.client;

import hellfirepvp.astralsorcery.client.screen.journal.ScreenJournalPerkTree;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.network.base.ASPacket;
import hellfirepvp.astralsorcery.common.perk.AbstractPerk;
import hellfirepvp.astralsorcery.common.perk.PerkTree;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class PktUnlockPerk
extends ASPacket<PktUnlockPerk> {
    private ResourceLocation perkKey = null;
    private boolean serverAccept = false;

    public PktUnlockPerk() {
    }

    public PktUnlockPerk(boolean serverAccepted, AbstractPerk perk) {
        this.serverAccept = serverAccepted;
        this.perkKey = perk.getRegistryName();
    }

    @Override
    @Nonnull
    public ASPacket.Encoder<PktUnlockPerk> encoder() {
        return (packet, buffer) -> {
            ByteBufUtils.writeOptional(buffer, packet.perkKey, ByteBufUtils::writeResourceLocation);
            buffer.writeBoolean(packet.serverAccept);
        };
    }

    @Override
    @Nonnull
    public ASPacket.Decoder<PktUnlockPerk> decoder() {
        return buffer -> {
            PktUnlockPerk pkt = new PktUnlockPerk();
            pkt.perkKey = ByteBufUtils.readOptional(buffer, ByteBufUtils::readResourceLocation);
            pkt.serverAccept = buffer.readBoolean();
            return pkt;
        };
    }

    @Override
    @Nonnull
    public ASPacket.Handler<PktUnlockPerk> handler() {
        return new ASPacket.Handler<PktUnlockPerk>(){

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void handleClient(PktUnlockPerk packet, NetworkEvent.Context context) {
                context.enqueueWork(() -> {
                    if (packet.serverAccept) {
                        PerkTree.PERK_TREE.getPerk(LogicalSide.CLIENT, packet.perkKey).ifPresent(perk -> {
                            Screen current = Minecraft.func_71410_x().field_71462_r;
                            if (current instanceof ScreenJournalPerkTree) {
                                Minecraft.func_71410_x().func_212871_a_(() -> ((ScreenJournalPerkTree)current).playUnlockAnimation((AbstractPerk)perk));
                            }
                        });
                    }
                });
            }

            @Override
            public void handle(PktUnlockPerk packet, NetworkEvent.Context context, LogicalSide side) {
                context.enqueueWork(() -> PerkTree.PERK_TREE.getPerk(side, packet.perkKey).ifPresent(perk -> {
                    ServerPlayerEntity player = context.getSender();
                    PlayerProgress prog = ResearchHelper.getProgress((PlayerEntity)player, LogicalSide.SERVER);
                    if (!prog.hasPerkUnlocked((AbstractPerk)perk) && prog.isValid() && perk.mayUnlockPerk(prog, (PlayerEntity)player) && ResearchManager.applyPerk((PlayerEntity)player, perk)) {
                        packet.replyWith(new PktUnlockPerk(true, (AbstractPerk)perk), context);
                    }
                }));
            }
        };
    }
}

