/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.network.play.server;

import hellfirepvp.astralsorcery.common.auxiliary.gateway.CelestialGatewayHandler;
import hellfirepvp.astralsorcery.common.data.world.GatewayCache;
import hellfirepvp.astralsorcery.common.network.base.ASPacket;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class PktUpdateGateways
extends ASPacket<PktUpdateGateways> {
    private Map<ResourceLocation, Collection<GatewayCache.GatewayNode>> positions = new HashMap<ResourceLocation, Collection<GatewayCache.GatewayNode>>();

    public PktUpdateGateways() {
    }

    public PktUpdateGateways(Map<ResourceLocation, Collection<GatewayCache.GatewayNode>> positions) {
        this.positions = positions;
    }

    @Override
    @Nonnull
    public ASPacket.Encoder<PktUpdateGateways> encoder() {
        return (packet, buffer) -> {
            buffer.writeInt(packet.positions.size());
            for (ResourceLocation dim : packet.positions.keySet()) {
                ByteBufUtils.writeResourceLocation(buffer, dim);
                ByteBufUtils.writeCollection(buffer, packet.positions.get(dim), (buf, node) -> node.write((PacketBuffer)buf));
            }
        };
    }

    @Override
    @Nonnull
    public ASPacket.Decoder<PktUpdateGateways> decoder() {
        return buffer -> {
            PktUpdateGateways pkt = new PktUpdateGateways();
            int dimSize = buffer.readInt();
            for (int i = 0; i < dimSize; ++i) {
                ResourceLocation dim = ByteBufUtils.readResourceLocation(buffer);
                pkt.positions.put(dim, ByteBufUtils.readList(buffer, GatewayCache.GatewayNode::read));
            }
            return pkt;
        };
    }

    @Override
    @Nonnull
    public ASPacket.Handler<PktUpdateGateways> handler() {
        return new ASPacket.Handler<PktUpdateGateways>(){

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void handleClient(PktUpdateGateways packet, NetworkEvent.Context context) {
                context.enqueueWork(() -> CelestialGatewayHandler.INSTANCE.updateClientCache(packet.positions));
            }

            @Override
            public void handle(PktUpdateGateways packet, NetworkEvent.Context context, LogicalSide side) {
            }
        };
    }
}

