/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.modifier;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.lib.RegistriesAS;
import hellfirepvp.astralsorcery.common.perk.PerkConverter;
import hellfirepvp.astralsorcery.common.perk.ProgressGatedPerk;
import hellfirepvp.astralsorcery.common.perk.source.AttributeConverterProvider;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.LogicalSide;

public class AttributeConverterPerk
extends ProgressGatedPerk
implements AttributeConverterProvider {
    private final Set<PerkConverter> converters = Sets.newHashSet();

    public AttributeConverterPerk(ResourceLocation name, float x, float y) {
        super(name, x, y);
    }

    public <T> T addConverter(PerkConverter converter) {
        this.converters.add(converter);
        return (T)this;
    }

    public <T> T addRangedConverter(float radius, PerkConverter converter) {
        return this.addConverter(converter.asRangedConverter(new Point2D.Float(this.getOffset().x, this.getOffset().y), radius));
    }

    @Override
    public Collection<PerkConverter> getConverters(PlayerEntity player, LogicalSide side, boolean ignoreRequirements) {
        if (this.modifiersDisabled(player, side)) {
            return Collections.emptyList();
        }
        if (!ignoreRequirements && ResearchHelper.getProgress(player, side).isPerkSealed(this)) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableSet(this.converters);
    }

    @Override
    public void applyPerkLogic(PlayerEntity player, LogicalSide side) {
    }

    @Override
    public void removePerkLogic(PlayerEntity player, LogicalSide side) {
    }

    @Override
    public void deserializeData(JsonObject perkData) {
        super.deserializeData(perkData);
        this.converters.clear();
        if (JSONUtils.func_151204_g((JsonObject)perkData, (String)"converters")) {
            JsonArray array = JSONUtils.func_151214_t((JsonObject)perkData, (String)"converters");
            for (int i = 0; i < array.size(); ++i) {
                JsonObject serializedConverter = JSONUtils.func_151210_l((JsonElement)array.get(i), (String)"converters[%s]");
                String key = JSONUtils.func_151200_h((JsonObject)serializedConverter, (String)"name");
                PerkConverter converter = (PerkConverter)RegistriesAS.REGISTRY_PERK_ATTRIBUTE_CONVERTERS.getValue(new ResourceLocation(key));
                if (converter == null) {
                    throw new JsonParseException("Unknown converter: " + key);
                }
                if (serializedConverter.has("radius")) {
                    float radius = JSONUtils.func_151217_k((JsonObject)serializedConverter, (String)"radius");
                    this.addRangedConverter(radius, converter);
                    continue;
                }
                this.addConverter(converter);
            }
        }
    }

    @Override
    public void serializeData(JsonObject perkData) {
        super.serializeData(perkData);
        if (!this.converters.isEmpty()) {
            JsonArray converters = new JsonArray();
            for (PerkConverter converter : this.converters) {
                JsonObject serializedConverter = new JsonObject();
                serializedConverter.addProperty("name", converter.getRegistryName().toString());
                if (converter instanceof PerkConverter.Radius) {
                    serializedConverter.addProperty("radius", (Number)Float.valueOf(((PerkConverter.Radius)converter).getRadius()));
                }
                converters.add((JsonElement)serializedConverter);
            }
            perkData.add("converters", (JsonElement)converters);
        }
    }
}

