/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.node.key;

import hellfirepvp.astralsorcery.common.data.config.base.ConfigEntry;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.lib.EffectsAS;
import hellfirepvp.astralsorcery.common.lib.PerkAttributeTypesAS;
import hellfirepvp.astralsorcery.common.perk.PerkAttributeHelper;
import hellfirepvp.astralsorcery.common.perk.node.KeyPerk;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.LogicalSide;

public class KeyBleed
extends KeyPerk {
    private static final int defaultBleedDuration = 40;
    private static final float defaultBleedChance = 0.25f;
    public static final Config CONFIG = new Config("key.bleed");

    public KeyBleed(ResourceLocation name, float x, float y) {
        super(name, x, y);
    }

    @Override
    public void attachListeners(LogicalSide side, IEventBus bus) {
        super.attachListeners(side, bus);
        bus.addListener(this::onAttack);
    }

    private void onAttack(LivingHurtEvent event) {
        LogicalSide side;
        PlayerEntity player;
        PlayerProgress prog;
        DamageSource source = event.getSource();
        if (source.func_76346_g() != null && source.func_76346_g() instanceof PlayerEntity && (prog = ResearchHelper.getProgress(player = (PlayerEntity)source.func_76346_g(), side = this.getSide((Entity)player))).hasPerkEffect(this)) {
            LivingEntity target = event.getEntityLiving();
            double chance = this.applyMultiplierD((Double)CONFIG.bleedChance.get());
            chance = PerkAttributeHelper.getOrCreateMap(player, side).modifyValue(player, prog, PerkAttributeTypesAS.ATTR_TYPE_BLEED_CHANCE, (float)chance);
            if ((double)rand.nextFloat() < chance) {
                EffectInstance pe;
                int stackCap = 3;
                stackCap = Math.round(PerkAttributeHelper.getOrCreateMap(player, side).modifyValue(player, prog, PerkAttributeTypesAS.ATTR_TYPE_BLEED_STACKS, stackCap));
                int duration = this.applyMultiplierI(((Integer)CONFIG.bleedDuration.get()).intValue());
                duration = Math.round(PerkAttributeHelper.getOrCreateMap(player, side).modifyValue(player, prog, PerkAttributeTypesAS.ATTR_TYPE_BLEED_DURATION, duration));
                int setAmplifier = 0;
                if (target.func_70644_a((Effect)EffectsAS.EFFECT_BLEED) && (pe = target.func_70660_b((Effect)EffectsAS.EFFECT_BLEED)) != null) {
                    setAmplifier = Math.min(pe.func_76458_c() + 1, stackCap - 1);
                }
                target.func_195064_c(new EffectInstance((Effect)EffectsAS.EFFECT_BLEED, duration, setAmplifier, false, true));
            }
        }
    }

    private static class Config
    extends ConfigEntry {
        private ForgeConfigSpec.IntValue bleedDuration;
        private ForgeConfigSpec.DoubleValue bleedChance;

        private Config(String section) {
            super(section);
        }

        @Override
        public void createEntries(ForgeConfigSpec.Builder cfgBuilder) {
            this.bleedDuration = cfgBuilder.comment("Defines the duration of the bleeding effect when applied. Refreshes this duration when a it is applied again").translation(this.translationKey("bleedDuration")).defineInRange("bleedDuration", 40, 5, 400);
            this.bleedChance = cfgBuilder.comment("Defines the base chance a bleed can/is applied when an entity is being hit by this entity").translation(this.translationKey("bleedChance")).defineInRange("bleedChance", 0.25, 0.01, 1.0);
        }
    }
}

