/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.node.root;

import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.event.AttributeEvent;
import hellfirepvp.astralsorcery.common.lib.ConstellationsAS;
import hellfirepvp.astralsorcery.common.lib.PerkAttributeTypesAS;
import hellfirepvp.astralsorcery.common.perk.PerkAttributeHelper;
import hellfirepvp.astralsorcery.common.perk.node.RootPerk;
import hellfirepvp.astralsorcery.common.perk.tick.PlayerTickPerk;
import hellfirepvp.astralsorcery.common.util.DiminishingMultiplier;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.stats.ServerStatisticsManager;
import net.minecraft.stats.Stats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.LogicalSide;

public class RootVicio
extends RootPerk
implements PlayerTickPerk {
    public static final RootPerk.Config CONFIG = new RootPerk.Config("root.vicio");
    private Map<ResourceLocation, Map<UUID, Integer>> moveTrackMap = new HashMap<ResourceLocation, Map<UUID, Integer>>();

    public RootVicio(ResourceLocation name, float x, float y) {
        super(name, CONFIG, ConstellationsAS.vicio, x, y);
    }

    @Override
    @Nonnull
    protected DiminishingMultiplier createMultiplier() {
        return new DiminishingMultiplier(10000L, 0.065f, 0.003f, 0.2f);
    }

    @Override
    public void removePerkLogic(PlayerEntity player, LogicalSide side) {
        super.removePerkLogic(player, side);
        if (side.isServer()) {
            this.moveTrackMap.computeIfAbsent(Stats.field_188100_j, s -> new HashMap()).remove(player.func_110124_au());
            this.moveTrackMap.computeIfAbsent(Stats.field_188102_l, s -> new HashMap()).remove(player.func_110124_au());
            this.moveTrackMap.computeIfAbsent(Stats.field_188104_p, s -> new HashMap()).remove(player.func_110124_au());
            this.moveTrackMap.computeIfAbsent(Stats.field_188110_v, s -> new HashMap()).remove(player.func_110124_au());
            this.moveTrackMap.computeIfAbsent(Stats.field_75946_m, s -> new HashMap()).remove(player.func_110124_au());
        }
    }

    @Override
    public void clearCaches(LogicalSide side) {
        super.clearCaches(side);
        if (side.isServer()) {
            this.moveTrackMap.clear();
        }
    }

    @Override
    public void onPlayerTick(PlayerEntity player, LogicalSide side) {
        if (!side.isServer() || !(player instanceof ServerPlayerEntity)) {
            return;
        }
        UUID uuid = player.func_110124_au();
        ServerPlayerEntity sPlayer = (ServerPlayerEntity)player;
        PlayerProgress prog = ResearchHelper.getProgress(player, side);
        ServerStatisticsManager mgr = sPlayer.func_147099_x();
        int walked = mgr.func_77444_a(Stats.field_199092_j.func_199076_b((Object)Stats.field_188100_j));
        int sprint = mgr.func_77444_a(Stats.field_199092_j.func_199076_b((Object)Stats.field_188102_l));
        int flown = mgr.func_77444_a(Stats.field_199092_j.func_199076_b((Object)Stats.field_188104_p));
        int elytra = mgr.func_77444_a(Stats.field_199092_j.func_199076_b((Object)Stats.field_188110_v));
        int swam = mgr.func_77444_a(Stats.field_199092_j.func_199076_b((Object)Stats.field_75946_m));
        int lastWalked = this.moveTrackMap.computeIfAbsent(Stats.field_188100_j, s -> new HashMap()).computeIfAbsent(uuid, u -> walked);
        int lastSprint = this.moveTrackMap.computeIfAbsent(Stats.field_188102_l, s -> new HashMap()).computeIfAbsent(uuid, u -> sprint);
        int lastFly = this.moveTrackMap.computeIfAbsent(Stats.field_188104_p, s -> new HashMap()).computeIfAbsent(uuid, u -> flown);
        int lastElytra = this.moveTrackMap.computeIfAbsent(Stats.field_188110_v, s -> new HashMap()).computeIfAbsent(uuid, u -> elytra);
        int lastSwam = this.moveTrackMap.computeIfAbsent(Stats.field_75946_m, s -> new HashMap()).computeIfAbsent(uuid, u -> swam);
        float added = 0.0f;
        if (walked > lastWalked) {
            if ((added += Math.min((float)(walked - lastWalked), 500.0f)) >= 500.0f) {
                added = 500.0f;
            }
            added *= 0.9f;
            this.moveTrackMap.get(Stats.field_188100_j).put(uuid, walked);
        }
        if (sprint > lastSprint) {
            if ((added += Math.min((float)(sprint - lastSprint), 500.0f)) >= 500.0f) {
                added = 500.0f;
            }
            added *= 0.8f;
            this.moveTrackMap.get(Stats.field_188102_l).put(uuid, sprint);
        }
        if (flown > lastFly) {
            added += Math.min((float)(flown - lastFly), 500.0f);
            added *= 0.3f;
            this.moveTrackMap.get(Stats.field_188104_p).put(uuid, flown);
        }
        if (elytra > lastElytra) {
            added += Math.min((float)(elytra - lastElytra), 500.0f);
            added *= 0.55f;
            this.moveTrackMap.get(Stats.field_188110_v).put(uuid, elytra);
        }
        if (swam > lastSwam) {
            added += Math.min((float)(swam - lastSwam), 500.0f);
            added *= 1.2f;
            this.moveTrackMap.get(Stats.field_75946_m).put(uuid, swam);
        }
        if (added > 0.0f) {
            added *= 0.05f;
            added = (float)((double)added * this.getExpMultiplier());
            added *= this.getDiminishingReturns(player);
            added *= PerkAttributeHelper.getOrCreateMap(player, side).getModifier(player, prog, PerkAttributeTypesAS.ATTR_TYPE_INC_PERK_EFFECT);
            added *= PerkAttributeHelper.getOrCreateMap(player, side).getModifier(player, prog, PerkAttributeTypesAS.ATTR_TYPE_INC_PERK_EXP);
            added = AttributeEvent.postProcessModded(player, PerkAttributeTypesAS.ATTR_TYPE_INC_PERK_EXP, added);
            ResearchManager.modifyExp(player, added);
        }
    }
}

