/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.reader;

import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.event.AttributeEvent;
import hellfirepvp.astralsorcery.common.perk.PerkAttributeLimiter;
import hellfirepvp.astralsorcery.common.perk.PerkAttributeMap;
import hellfirepvp.astralsorcery.common.perk.reader.PerkAttributeReader;
import hellfirepvp.astralsorcery.common.perk.reader.PerkStatistic;
import hellfirepvp.astralsorcery.common.perk.type.ModifierType;
import hellfirepvp.astralsorcery.common.perk.type.PerkAttributeType;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import org.apache.commons.lang3.tuple.Pair;

public class ReaderAddedPercentage
extends PerkAttributeReader {
    protected float defaultValue;

    public ReaderAddedPercentage(PerkAttributeType attribute) {
        super(attribute);
        this.defaultValue = attribute.isMultiplicative() ? 1.0f : 0.0f;
    }

    public <T extends ReaderAddedPercentage> T setDefaultValue(float defaultValue) {
        if (!this.getType().isMultiplicative()) {
            this.defaultValue = defaultValue;
        }
        return (T)((Object)this);
    }

    @Override
    public double getDefaultValue(PerkAttributeMap statMap, PlayerEntity player, LogicalSide side) {
        return this.defaultValue;
    }

    @Override
    public double getModifierValueForMode(PerkAttributeMap statMap, PlayerEntity player, LogicalSide side, ModifierType mode) {
        double value = statMap.getModifier(player, ResearchHelper.getProgress(player, side), this.getType(), mode);
        if (mode == ModifierType.ADDITION) {
            value /= 100.0;
            value += 1.0;
        }
        return value;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public PerkStatistic getStatistics(PerkAttributeMap statMap, PlayerEntity player) {
        String limitStr = "";
        Double limit = null;
        if (PerkAttributeLimiter.hasLimit(this.getType())) {
            Pair<Double, Double> limits = PerkAttributeLimiter.getLimit(this.getType());
            limit = (Double)limits.getRight();
            limitStr = I18n.func_135052_a((String)"perk.reader.astralsorcery.limit.percent", (Object[])new Object[]{MathHelper.func_76128_c((double)(limit * 100.0))});
        }
        double value = statMap.modifyValue(player, ResearchHelper.getProgress(player, LogicalSide.CLIENT), this.getType(), (float)this.getDefaultValue(statMap, player, LogicalSide.CLIENT));
        if (this.getType().isMultiplicative()) {
            value -= 1.0;
        }
        String postProcess = "";
        double postValue = AttributeEvent.postProcessModded(player, this.getType(), value);
        if (Math.abs(value - postValue) > 1.0E-4 && (limit == null || Math.abs(postValue - limit) > 1.0E-4)) {
            if (Math.abs(postValue) >= 1.0E-4) {
                postProcess = I18n.func_135052_a((String)"perk.reader.astralsorcery.postprocess.default", (Object[])new Object[]{(postValue >= 0.0 ? "+" : "") + ReaderAddedPercentage.formatDecimal(postValue) + "%"});
            }
            value = postValue;
        }
        String strOut = (value >= 0.0 ? "+" : "") + ReaderAddedPercentage.formatDecimal(value) + "%";
        return new PerkStatistic(this.getType(), strOut, limitStr, postProcess);
    }
}

