/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.tree;

import hellfirepvp.astralsorcery.client.lib.SpritesAS;
import hellfirepvp.astralsorcery.client.resource.SpriteSheetResource;
import hellfirepvp.astralsorcery.client.screen.journal.perk.BatchPerkContext;
import hellfirepvp.astralsorcery.client.screen.journal.perk.PerkRender;
import hellfirepvp.astralsorcery.client.screen.journal.perk.PerkRenderGroup;
import hellfirepvp.astralsorcery.client.screen.journal.perk.group.PerkPointRenderGroup;
import hellfirepvp.astralsorcery.client.util.RenderingGuiUtils;
import hellfirepvp.astralsorcery.client.util.draw.BufferContext;
import hellfirepvp.astralsorcery.common.perk.AbstractPerk;
import hellfirepvp.astralsorcery.common.perk.AllocationStatus;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.util.Tuple;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PerkTreePoint<T extends AbstractPerk>
implements PerkRender {
    private final Point2D.Float offset;
    private final T perk;
    private int renderSize;
    private static final int spriteSize = 11;

    public PerkTreePoint(T perk, Point2D.Float offset) {
        this.offset = offset;
        this.perk = perk;
        this.renderSize = 11;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addGroups(Collection<PerkRenderGroup> groups) {
        groups.add(PerkPointRenderGroup.INSTANCE);
    }

    public void setRenderSize(int renderSize) {
        this.renderSize = renderSize;
    }

    public int getRenderSize() {
        return this.renderSize;
    }

    public T getPerk() {
        return this.perk;
    }

    public Point2D.Float getOffset() {
        return this.offset;
    }

    @Override
    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public Rectangle2D.Float renderPerkAtBatch(BatchPerkContext drawCtx, AllocationStatus status, long spriteOffsetTick, float pTicks, float x, float y, float zLevel, float scale) {
        SpriteSheetResource tex = this.getFlareSprite(status);
        BatchPerkContext.TextureObjectGroup grp = PerkPointRenderGroup.INSTANCE.getGroup(tex);
        if (grp == null) {
            return new Rectangle2D.Float();
        }
        BufferContext buf = drawCtx.getContext(grp);
        float size = (float)this.renderSize * scale;
        Tuple<Float, Float> frameUV = tex.getUVOffset(spriteOffsetTick);
        RenderingGuiUtils.rect(buf, x - size, y - size, zLevel, size * 2.0f, size * 2.0f).tex(((Float)frameUV.func_76341_a()).floatValue(), ((Float)frameUV.func_76340_b()).floatValue(), tex.getULength(), tex.getVLength()).draw();
        return new Rectangle2D.Float(-size, -size, size * 2.0f, size * 2.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected SpriteSheetResource getFlareSprite(AllocationStatus status) {
        SpriteSheetResource tex;
        switch (status) {
            case ALLOCATED: {
                tex = SpritesAS.SPR_PERK_ACTIVE;
                break;
            }
            case UNLOCKABLE: {
                tex = SpritesAS.SPR_PERK_ACTIVATEABLE;
                break;
            }
            default: {
                tex = SpritesAS.SPR_PERK_INACTIVE;
            }
        }
        return tex;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected SpriteSheetResource getHaloSprite(AllocationStatus status) {
        SpriteSheetResource tex;
        switch (status) {
            case ALLOCATED: {
                tex = SpritesAS.SPR_PERK_HALO_ACTIVE;
                break;
            }
            case UNLOCKABLE: {
                tex = SpritesAS.SPR_PERK_HALO_ACTIVATEABLE;
                break;
            }
            default: {
                tex = SpritesAS.SPR_PERK_HALO_INACTIVE;
            }
        }
        return tex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PerkTreePoint that = (PerkTreePoint)o;
        return Objects.equals(this.offset, that.offset);
    }

    public int hashCode() {
        return Objects.hash(this.offset);
    }
}

