/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.registry.internal;

import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffectProvider;
import hellfirepvp.astralsorcery.common.constellation.engraving.EngravingEffect;
import hellfirepvp.astralsorcery.common.constellation.mantle.MantleEffect;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.effect.AltarRecipeEffect;
import hellfirepvp.astralsorcery.common.crystal.CrystalProperty;
import hellfirepvp.astralsorcery.common.crystal.calc.PropertyUsage;
import hellfirepvp.astralsorcery.common.perk.PerkConverter;
import hellfirepvp.astralsorcery.common.perk.modifier.PerkAttributeModifier;
import hellfirepvp.astralsorcery.common.perk.reader.PerkAttributeReader;
import hellfirepvp.astralsorcery.common.perk.type.PerkAttributeType;
import hellfirepvp.astralsorcery.common.registry.RegistryBlocks;
import hellfirepvp.astralsorcery.common.registry.RegistryConstellationEffects;
import hellfirepvp.astralsorcery.common.registry.RegistryContainerTypes;
import hellfirepvp.astralsorcery.common.registry.RegistryCrystalProperties;
import hellfirepvp.astralsorcery.common.registry.RegistryCrystalPropertyUsages;
import hellfirepvp.astralsorcery.common.registry.RegistryDataSerializers;
import hellfirepvp.astralsorcery.common.registry.RegistryEffects;
import hellfirepvp.astralsorcery.common.registry.RegistryEnchantments;
import hellfirepvp.astralsorcery.common.registry.RegistryEngravingEffects;
import hellfirepvp.astralsorcery.common.registry.RegistryEntities;
import hellfirepvp.astralsorcery.common.registry.RegistryFluids;
import hellfirepvp.astralsorcery.common.registry.RegistryItems;
import hellfirepvp.astralsorcery.common.registry.RegistryLoot;
import hellfirepvp.astralsorcery.common.registry.RegistryMantleEffects;
import hellfirepvp.astralsorcery.common.registry.RegistryRecipeSerializers;
import hellfirepvp.astralsorcery.common.registry.RegistryRecipeTypes;
import hellfirepvp.astralsorcery.common.registry.RegistryResearch;
import hellfirepvp.astralsorcery.common.registry.RegistrySounds;
import hellfirepvp.astralsorcery.common.registry.RegistryStructures;
import hellfirepvp.astralsorcery.common.registry.RegistryTileEntities;
import hellfirepvp.astralsorcery.common.registry.RegistryWorldGeneration;
import hellfirepvp.astralsorcery.common.registry.internal.InternalRegistryPrimer;
import hellfirepvp.astralsorcery.common.starlight.transmission.registry.SourceClassRegistry;
import hellfirepvp.astralsorcery.common.starlight.transmission.registry.TransmissionClassRegistry;
import hellfirepvp.astralsorcery.common.structure.types.StructureType;
import hellfirepvp.observerlib.api.ObserverProvider;
import hellfirepvp.observerlib.api.structure.MatchableStructure;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.potion.Effect;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.Feature;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DataSerializerEntry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class PrimerEventHandler {
    private InternalRegistryPrimer registry;

    public PrimerEventHandler(InternalRegistryPrimer registry) {
        this.registry = registry;
    }

    public void attachEventHandlers(IEventBus eventBus) {
        eventBus.addGenericListener(Item.class, this::registerItems);
        eventBus.addGenericListener(Block.class, this::registerBlocks);
        eventBus.addGenericListener(Fluid.class, this::registerFluids);
        eventBus.addGenericListener(TileEntityType.class, this::registerTiles);
        eventBus.addGenericListener(EntityType.class, this::registerEntities);
        eventBus.addGenericListener(Biome.class, this::registerBiomes);
        eventBus.addGenericListener(Feature.class, this::registerFeatures);
        eventBus.addGenericListener(Effect.class, this::registerEffects);
        eventBus.addGenericListener(Enchantment.class, this::registerEnchantments);
        eventBus.addGenericListener(SoundEvent.class, this::registerSounds);
        eventBus.addGenericListener(GlobalLootModifierSerializer.class, this::registerGlobalLootModifierSerializers);
        eventBus.addGenericListener(IConstellation.class, this::registerConstellations);
        eventBus.addGenericListener(DataSerializerEntry.class, this::registerDataSerializers);
        eventBus.addGenericListener(IRecipeSerializer.class, this::registerRecipeSerializers);
        eventBus.addGenericListener(MatchableStructure.class, this::registerStructures);
        eventBus.addGenericListener(StructureType.class, this::registerStructureTypes);
        eventBus.addGenericListener(ObserverProvider.class, this::registerStructureProviders);
        eventBus.addGenericListener(ConstellationEffectProvider.class, this::registerConstellationEffects);
        eventBus.addGenericListener(MantleEffect.class, this::registerMantleEffects);
        eventBus.addGenericListener(EngravingEffect.class, this::registerEngravingEffects);
        eventBus.addGenericListener(PerkAttributeType.class, this::registerPerkAttributeTypes);
        eventBus.addGenericListener(PerkConverter.class, this::registerPerkConverters);
        eventBus.addGenericListener(PerkAttributeModifier.class, this::registerPerkCustomModifiers);
        eventBus.addGenericListener(PerkAttributeReader.class, this::registerPerkAttributeReaders);
        eventBus.addGenericListener(ContainerType.class, this::registerContainerTypes);
        eventBus.addGenericListener(CrystalProperty.class, this::registerCrystalProperties);
        eventBus.addGenericListener(PropertyUsage.class, this::registerCrystalUsages);
        eventBus.addGenericListener(AltarRecipeEffect.class, this::registerAltarRecipeEffects);
    }

    private void registerRemainingData() {
        RegistryConstellationEffects.init();
        RegistryMantleEffects.init();
        RegistryEngravingEffects.init();
        RegistryStructures.init();
        RegistryCrystalPropertyUsages.init();
        RegistryCrystalProperties.init();
        RegistryCrystalProperties.initDefaultAttributes();
        RegistryRecipeTypes.init();
        RegistryRecipeSerializers.init();
        RegistryResearch.init();
        TransmissionClassRegistry.setupRegistry();
        SourceClassRegistry.setupRegistry();
    }

    private void registerItems(RegistryEvent.Register<Item> event) {
        RegistryItems.registerItems();
        RegistryItems.registerItemBlocks();
        RegistryItems.registerFluidContainerItems();
        RegistryItems.registerDispenseBehaviors();
        this.fillRegistry(event.getRegistry().getRegistrySuperType(), event.getRegistry());
        this.registerRemainingData();
    }

    private void registerBlocks(RegistryEvent.Register<Block> event) {
        RegistryFluids.registerFluids();
        RegistryBlocks.registerBlocks();
        RegistryBlocks.registerFluidBlocks();
        this.fillRegistry(event.getRegistry().getRegistrySuperType(), event.getRegistry());
    }

    private void registerFluids(RegistryEvent.Register<Fluid> event) {
        this.fillRegistry(event.getRegistry().getRegistrySuperType(), event.getRegistry());
    }

    private void registerTiles(RegistryEvent.Register<TileEntityType<?>> event) {
        RegistryTileEntities.registerTiles();
        this.fillRegistry(event.getRegistry().getRegistrySuperType(), event.getRegistry());
    }

    private void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        RegistryEntities.init();
        this.fillRegistry(event.getRegistry().getRegistrySuperType(), event.getRegistry());
    }

    private void registerBiomes(RegistryEvent.Register<Biome> event) {
        this.fillRegistry(event.getRegistry().getRegistrySuperType(), event.getRegistry());
    }

    private void registerFeatures(RegistryEvent.Register<Feature<?>> event) {
        RegistryWorldGeneration.registerFeatures();
        this.fillRegistry(event.getRegistry().getRegistrySuperType(), event.getRegistry());
    }

    private void registerEffects(RegistryEvent.Register<Effect> event) {
        RegistryEffects.init();
        this.fillRegistry(event.getRegistry().getRegistrySuperType(), event.getRegistry());
    }

    private void registerEnchantments(RegistryEvent.Register<Enchantment> event) {
        RegistryEnchantments.init();
        this.fillRegistry(event.getRegistry().getRegistrySuperType(), event.getRegistry());
    }

    private void registerGlobalLootModifierSerializers(RegistryEvent.Register<GlobalLootModifierSerializer<?>> event) {
        RegistryLoot.init();
        this.fillRegistry(event.getRegistry().getRegistrySuperType(), event.getRegistry());
    }

    private void registerConstellations(RegistryEvent.Register<IConstellation> event) {
        this.fillRegistry(event.getRegistry().getRegistrySuperType(), event.getRegistry());
    }

    private void registerConstellationEffects(RegistryEvent.Register<ConstellationEffectProvider> event) {
        this.fillRegistry(event.getRegistry().getRegistrySuperType(), event.getRegistry());
    }

    private void registerMantleEffects(RegistryEvent.Register<MantleEffect> event) {
        this.fillRegistry(event.getRegistry().getRegistrySuperType(), event.getRegistry());
    }

    private void registerEngravingEffects(RegistryEvent.Register<EngravingEffect> event) {
        this.fillRegistry(event.getRegistry().getRegistrySuperType(), event.getRegistry());
    }

    private void registerPerkAttributeTypes(RegistryEvent.Register<PerkAttributeType> event) {
        this.fillRegistry(event.getRegistry().getRegistrySuperType(), event.getRegistry());
    }

    private void registerPerkConverters(RegistryEvent.Register<PerkConverter> event) {
        this.fillRegistry(event.getRegistry().getRegistrySuperType(), event.getRegistry());
    }

    private void registerPerkCustomModifiers(RegistryEvent.Register<PerkAttributeModifier> event) {
        this.fillRegistry(event.getRegistry().getRegistrySuperType(), event.getRegistry());
    }

    private void registerPerkAttributeReaders(RegistryEvent.Register<PerkAttributeReader> event) {
        this.fillRegistry(event.getRegistry().getRegistrySuperType(), event.getRegistry());
    }

    private void registerContainerTypes(RegistryEvent.Register<ContainerType<?>> event) {
        RegistryContainerTypes.init();
        this.fillRegistry(event.getRegistry().getRegistrySuperType(), event.getRegistry());
    }

    private void registerCrystalProperties(RegistryEvent.Register<CrystalProperty> event) {
        this.fillRegistry(event.getRegistry().getRegistrySuperType(), event.getRegistry());
    }

    private void registerCrystalUsages(RegistryEvent.Register<PropertyUsage> event) {
        this.fillRegistry(event.getRegistry().getRegistrySuperType(), event.getRegistry());
    }

    private void registerAltarRecipeEffects(RegistryEvent.Register<AltarRecipeEffect> event) {
        RegistryRecipeTypes.initAltarEffects();
        this.fillRegistry(event.getRegistry().getRegistrySuperType(), event.getRegistry());
    }

    private void registerDataSerializers(RegistryEvent.Register<DataSerializerEntry> event) {
        RegistryDataSerializers.registerSerializers();
        this.fillRegistry(event.getRegistry().getRegistrySuperType(), event.getRegistry());
    }

    private void registerRecipeSerializers(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        this.fillRegistry(event.getRegistry().getRegistrySuperType(), event.getRegistry());
    }

    private void registerStructures(RegistryEvent.Register<MatchableStructure> event) {
        this.fillRegistry(event.getRegistry().getRegistrySuperType(), event.getRegistry());
    }

    private void registerStructureProviders(RegistryEvent.Register<ObserverProvider> event) {
        this.fillRegistry(event.getRegistry().getRegistrySuperType(), event.getRegistry());
    }

    private void registerStructureTypes(RegistryEvent.Register<StructureType> event) {
        this.fillRegistry(event.getRegistry().getRegistrySuperType(), event.getRegistry());
    }

    private void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        RegistrySounds.init();
        this.fillRegistry(event.getRegistry().getRegistrySuperType(), event.getRegistry());
    }

    private <T extends IForgeRegistryEntry<T>> void fillRegistry(Class<T> registrySuperType, IForgeRegistry<T> forgeRegistry) {
        this.registry.getEntries(registrySuperType).forEach(e -> forgeRegistry.register((IForgeRegistryEntry)e));
    }
}

