/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.starlight.network;

import hellfirepvp.astralsorcery.common.starlight.network.TransmissionWorldHandler;
import hellfirepvp.observerlib.common.util.tick.ITickHandler;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.event.TickEvent;

public class StarlightTransmissionHandler
implements ITickHandler {
    private static final StarlightTransmissionHandler instance = new StarlightTransmissionHandler();
    private Map<DimensionType, TransmissionWorldHandler> worldHandlers = new HashMap<DimensionType, TransmissionWorldHandler>();

    private StarlightTransmissionHandler() {
    }

    public static StarlightTransmissionHandler getInstance() {
        return instance;
    }

    public void tick(TickEvent.Type type, Object ... context) {
        World world = (World)context[0];
        if (world.func_201670_d()) {
            return;
        }
        this.worldHandlers.computeIfAbsent(world.func_201675_m().func_186058_p(), TransmissionWorldHandler::new).tick(world);
    }

    public void clearServer() {
        this.worldHandlers.values().forEach(TransmissionWorldHandler::clear);
        this.worldHandlers.clear();
    }

    public void informWorldUnload(IWorld world) {
        DimensionType dimType = world.func_201675_m().func_186058_p();
        TransmissionWorldHandler handle = this.worldHandlers.get(dimType);
        if (handle != null) {
            handle.clear();
        }
        this.worldHandlers.remove(dimType);
    }

    @Nullable
    public TransmissionWorldHandler getWorldHandler(IWorld world) {
        if (world == null) {
            return null;
        }
        return this.worldHandlers.get(world.func_201675_m().func_186058_p());
    }

    public EnumSet<TickEvent.Type> getHandledTypes() {
        return EnumSet.of(TickEvent.Type.WORLD);
    }

    public boolean canFire(TickEvent.Phase phase) {
        return phase == TickEvent.Phase.END;
    }

    public String getName() {
        return "Starlight Transmission Handler";
    }
}

