/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.starlight.network;

import hellfirepvp.astralsorcery.common.block.base.BlockStarlightRecipient;
import hellfirepvp.astralsorcery.common.crystal.CrystalCalculations;
import hellfirepvp.astralsorcery.common.data.sync.SyncDataHolder;
import hellfirepvp.astralsorcery.common.data.sync.server.DataLightBlockEndpoints;
import hellfirepvp.astralsorcery.common.data.sync.server.DataLightConnections;
import hellfirepvp.astralsorcery.common.starlight.IIndependentStarlightSource;
import hellfirepvp.astralsorcery.common.starlight.WorldNetworkHandler;
import hellfirepvp.astralsorcery.common.starlight.network.TransmissionWorldHandler;
import hellfirepvp.astralsorcery.common.starlight.transmission.IPrismTransmissionNode;
import hellfirepvp.astralsorcery.common.starlight.transmission.ITransmissionReceiver;
import hellfirepvp.astralsorcery.common.starlight.transmission.NodeConnection;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class TransmissionChain {
    private List<ChunkPos> involvedChunks = new LinkedList<ChunkPos>();
    private List<LightConnection> foundConnections = new LinkedList<LightConnection>();
    private Map<BlockPos, Float> remainMultiplierMap = new HashMap<BlockPos, Float>();
    private Set<BlockPos> uncheckedEndpointsBlock = new HashSet<BlockPos>();
    private Set<BlockPos> resolvedNormalBlockPositions = new HashSet<BlockPos>();
    private Set<ITransmissionReceiver> endpointsNodes = new HashSet<ITransmissionReceiver>();
    private Set<IPrismTransmissionNode> transmissionUpdateList = new HashSet<IPrismTransmissionNode>();
    private final WorldNetworkHandler handler;
    private final IPrismTransmissionNode sourceNode;

    private TransmissionChain(WorldNetworkHandler netHandler, IPrismTransmissionNode sourceNode) {
        this.handler = netHandler;
        this.sourceNode = sourceNode;
    }

    public static void buildNetworkChain(World world, TransmissionWorldHandler handle, IIndependentStarlightSource source, WorldNetworkHandler netHandler, BlockPos sourcePos) {
        TransmissionChain chain = TransmissionChain.buildFromSource(netHandler, sourcePos);
        handle.updateNetworkData(world, chain, source, netHandler, sourcePos);
        SyncDataHolder.executeServer(SyncDataHolder.DATA_LIGHT_CONNECTIONS, DataLightConnections.class, data -> data.updateNewConnectionsThreaded(netHandler.getWorld().func_201675_m().func_186058_p(), chain.getFoundConnections()));
        SyncDataHolder.executeServer(SyncDataHolder.DATA_LIGHT_BLOCK_ENDPOINTS, DataLightBlockEndpoints.class, data -> data.updateNewEndpoints(netHandler.getWorld().func_201675_m().func_186058_p(), chain.getResolvedNormalBlockPositions()));
    }

    private static TransmissionChain buildFromSource(WorldNetworkHandler netHandler, BlockPos at) {
        TransmissionChain chain = new TransmissionChain(netHandler, null);
        IPrismTransmissionNode node = netHandler.getTransmissionNode(at);
        if (node != null) {
            chain = new TransmissionChain(netHandler, node);
            chain.recBuildChain(node, 1.0f, new LinkedList<BlockPos>());
        }
        chain.calculateInvolvedChunks();
        chain.resolveLoadedEndpoints(netHandler.getWorld());
        return chain;
    }

    private void resolveLoadedEndpoints(World world) {
        for (BlockPos pos : this.uncheckedEndpointsBlock) {
            MiscUtils.executeWithChunk((IWorldReader)world, pos, () -> {
                BlockState state = world.func_180495_p(pos);
                Block b = state.func_177230_c();
                if (b instanceof BlockStarlightRecipient) {
                    return;
                }
                this.resolvedNormalBlockPositions.add(pos);
            });
        }
    }

    protected void updatePosAsResolved(World world, BlockPos pos) {
        if (this.uncheckedEndpointsBlock.contains(pos) && !this.resolvedNormalBlockPositions.contains(pos)) {
            this.resolvedNormalBlockPositions.add(pos);
            SyncDataHolder.executeServer(SyncDataHolder.DATA_LIGHT_BLOCK_ENDPOINTS, DataLightBlockEndpoints.class, data -> data.updateNewEndpoint(world.func_201675_m().func_186058_p(), pos));
        }
    }

    private void recBuildChain(IPrismTransmissionNode node, float lossMultiplier, LinkedList<BlockPos> prevPath) {
        if (lossMultiplier <= 0.001f) {
            return;
        }
        float lossPerc = CrystalCalculations.getThroughputMultiplier(node.getTransmissionProperties());
        List<NodeConnection<IPrismTransmissionNode>> next = node.queryNext(this.handler);
        float nextLoss = lossMultiplier * (lossPerc *= node.getAdditionalTransmissionLossMultiplier()) / (float)next.size();
        prevPath.push(node.getLocationPos());
        if (node.needsTransmissionUpdate()) {
            this.transmissionUpdateList.add(node);
        }
        for (NodeConnection<IPrismTransmissionNode> nextNode : next) {
            IPrismTransmissionNode trNode = nextNode.getNode();
            if (!nextNode.canConnect()) continue;
            BlockPos nextPos = nextNode.getTo();
            this.addIfNonExistentConnection(node.getLocationPos(), nextPos);
            if (prevPath.contains(nextPos)) continue;
            this.remainMultiplierMap.merge(nextPos, Float.valueOf(nextLoss), (current, newNext) -> Float.valueOf(current.floatValue() + newNext.floatValue()));
            if (trNode != null) {
                if (trNode instanceof ITransmissionReceiver) {
                    if (this.endpointsNodes.contains(trNode)) continue;
                    this.endpointsNodes.add((ITransmissionReceiver)trNode);
                    continue;
                }
                this.recBuildChain(trNode, nextLoss, prevPath);
                continue;
            }
            this.uncheckedEndpointsBlock.add(nextPos);
        }
        prevPath.pop();
    }

    private void calculateInvolvedChunks() {
        for (BlockPos nodePos : this.remainMultiplierMap.keySet()) {
            ChunkPos ch = new ChunkPos(nodePos);
            if (this.involvedChunks.contains(ch)) continue;
            this.involvedChunks.add(ch);
        }
    }

    public Set<BlockPos> getResolvedNormalBlockPositions() {
        return this.resolvedNormalBlockPositions;
    }

    public IPrismTransmissionNode getSourceNode() {
        return this.sourceNode;
    }

    private void addIfNonExistentConnection(BlockPos start, BlockPos end) {
        LightConnection newCon = new LightConnection(start, end);
        if (!this.foundConnections.contains(newCon)) {
            this.foundConnections.add(newCon);
        }
    }

    public Set<IPrismTransmissionNode> getTransmissionUpdateList() {
        return this.transmissionUpdateList;
    }

    public List<ChunkPos> getInvolvedChunks() {
        return this.involvedChunks;
    }

    public Map<BlockPos, Float> getLossMultipliers() {
        return this.remainMultiplierMap;
    }

    public List<LightConnection> getFoundConnections() {
        return this.foundConnections;
    }

    public Set<ITransmissionReceiver> getEndpointsNodes() {
        return this.endpointsNodes;
    }

    public Set<BlockPos> getUncheckedEndpointsBlock() {
        return this.uncheckedEndpointsBlock;
    }

    public static class LightConnection {
        private final BlockPos start;
        private final BlockPos end;

        public LightConnection(BlockPos start, BlockPos end) {
            this.start = start;
            this.end = end;
        }

        public BlockPos getStart() {
            return this.start;
        }

        public BlockPos getEnd() {
            return this.end;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LightConnection that = (LightConnection)o;
            return Objects.equals(this.end, that.end) && Objects.equals(this.start, that.start);
        }

        public int hashCode() {
            int result = this.start != null ? this.start.hashCode() : 0;
            result = 31 * result + (this.end != null ? this.end.hashCode() : 0);
            return result;
        }
    }
}

