/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.starlight.network;

import hellfirepvp.astralsorcery.common.starlight.network.StarlightTransmissionHandler;
import hellfirepvp.astralsorcery.common.starlight.network.StarlightUpdateHandler;
import hellfirepvp.astralsorcery.common.starlight.network.TransmissionWorldHandler;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.IEventBus;

public class TransmissionChunkTracker {
    public static final TransmissionChunkTracker INSTANCE = new TransmissionChunkTracker();

    private TransmissionChunkTracker() {
    }

    public void attachListeners(IEventBus eventBus) {
        eventBus.addListener(this::onChLoad);
        eventBus.addListener(this::onChUnload);
        eventBus.addListener(this::onWorldLoad);
        eventBus.addListener(this::onWorldUnload);
    }

    private void onChLoad(ChunkEvent.Load event) {
        TransmissionWorldHandler handle = StarlightTransmissionHandler.getInstance().getWorldHandler(event.getWorld());
        if (handle != null) {
            handle.informChunkLoad(event.getChunk().func_76632_l());
        }
    }

    private void onChUnload(ChunkEvent.Unload event) {
        TransmissionWorldHandler handle = StarlightTransmissionHandler.getInstance().getWorldHandler(event.getWorld());
        if (handle != null) {
            handle.informChunkUnload(event.getChunk().func_76632_l());
        }
    }

    private void onWorldLoad(WorldEvent.Load event) {
        if (event.getWorld().func_201670_d()) {
            return;
        }
        StarlightUpdateHandler.getInstance().informWorldLoad(event.getWorld());
    }

    private void onWorldUnload(WorldEvent.Unload event) {
    }
}

