/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.starlight.network;

import com.google.common.collect.ImmutableList;
import hellfirepvp.astralsorcery.common.block.base.BlockStarlightRecipient;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.data.sync.SyncDataHolder;
import hellfirepvp.astralsorcery.common.data.sync.server.DataLightBlockEndpoints;
import hellfirepvp.astralsorcery.common.data.sync.server.DataLightConnections;
import hellfirepvp.astralsorcery.common.starlight.IIndependentStarlightSource;
import hellfirepvp.astralsorcery.common.starlight.WorldNetworkHandler;
import hellfirepvp.astralsorcery.common.starlight.network.StarlightNetworkRegistry;
import hellfirepvp.astralsorcery.common.starlight.network.TransmissionChain;
import hellfirepvp.astralsorcery.common.starlight.transmission.IPrismTransmissionNode;
import hellfirepvp.astralsorcery.common.starlight.transmission.ITransmissionReceiver;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;

public class TransmissionWorldHandler {
    private static final Random rand = new Random();
    private Map<ChunkPos, List<IIndependentStarlightSource>> involvedSourceMap = new HashMap<ChunkPos, List<IIndependentStarlightSource>>();
    private Map<IIndependentStarlightSource, List<ChunkPos>> activeChunkMap = new HashMap<IIndependentStarlightSource, List<ChunkPos>>();
    private Map<IIndependentStarlightSource, TransmissionChain> cachedSourceChain = new HashMap<IIndependentStarlightSource, TransmissionChain>();
    private Map<BlockPos, List<IIndependentStarlightSource>> posToSourceMap = new HashMap<BlockPos, List<IIndependentStarlightSource>>();
    private Set<BlockPos> sourcePosBuilding = new HashSet<BlockPos>();
    private final DimensionType dimType;

    public TransmissionWorldHandler(DimensionType dimType) {
        this.dimType = dimType;
    }

    public void tick(World world) {
        WorldNetworkHandler handler = WorldNetworkHandler.getNetworkHandler(world);
        for (Tuple<BlockPos, IIndependentStarlightSource> sourceTuple : handler.getAllSources()) {
            BlockPos at = (BlockPos)sourceTuple.func_76341_a();
            IIndependentStarlightSource source = (IIndependentStarlightSource)sourceTuple.func_76340_b();
            if (!this.cachedSourceChain.containsKey(source)) {
                if (this.sourcePosBuilding.contains(at)) continue;
                this.sourcePosBuilding.add(at);
                this.buildNetworkChain(world, source, handler, at);
                continue;
            }
            List<ChunkPos> activeChunks = this.activeChunkMap.get(source);
            if (activeChunks == null || activeChunks.isEmpty()) continue;
            TransmissionChain chain = this.cachedSourceChain.get(source);
            double starlight = source.produceStarlightTick(world, at);
            IWeakConstellation type = source.getStarlightType();
            if (type == null) continue;
            Map<BlockPos, Float> lossMultipliers = chain.getLossMultipliers();
            for (ITransmissionReceiver rec : chain.getEndpointsNodes()) {
                BlockPos pos = rec.getLocationPos();
                Float multiplier = lossMultipliers.get(pos);
                if (multiplier == null) continue;
                rec.onStarlightReceive(world, type, starlight * (double)multiplier.floatValue());
            }
            if (starlight > 0.1) {
                for (IPrismTransmissionNode node : chain.getTransmissionUpdateList()) {
                    node.onTransmissionTick(world);
                }
            }
            for (BlockPos endPointPos : chain.getUncheckedEndpointsBlock()) {
                MiscUtils.executeWithChunk((IWorldReader)world, endPointPos, () -> {
                    BlockState endState = world.func_180495_p(endPointPos);
                    Block b = endState.func_177230_c();
                    if (b instanceof BlockStarlightRecipient) {
                        Float multiplier = (Float)lossMultipliers.get(endPointPos);
                        if (multiplier != null) {
                            ((BlockStarlightRecipient)b).receiveStarlight(world, rand, endPointPos, type, starlight * (double)multiplier.floatValue());
                        }
                    } else {
                        StarlightNetworkRegistry.IStarlightBlockHandler handle = StarlightNetworkRegistry.getStarlightHandler(world, endPointPos, endState, type);
                        if (handle != null) {
                            Float multiplier = (Float)lossMultipliers.get(endPointPos);
                            if (multiplier != null) {
                                handle.receiveStarlight(world, rand, endPointPos, endState, type, starlight * (double)multiplier.floatValue());
                            }
                        } else {
                            chain.updatePosAsResolved(world, endPointPos);
                        }
                    }
                });
            }
        }
    }

    private void buildNetworkChain(World world, IIndependentStarlightSource source, WorldNetworkHandler handler, BlockPos sourcePos) {
        TransmissionChain.buildNetworkChain(world, this, source, handler, sourcePos);
    }

    void updateNetworkData(World world, TransmissionChain chain, IIndependentStarlightSource source, WorldNetworkHandler handle, BlockPos sourcePos) {
        List sources;
        this.sourcePosBuilding.remove(sourcePos);
        this.cachedSourceChain.put(source, chain);
        LinkedList activeChunks = new LinkedList();
        for (ChunkPos chunkPos : chain.getInvolvedChunks()) {
            sources = this.involvedSourceMap.computeIfAbsent(chunkPos, k -> new LinkedList());
            sources.add(source);
            MiscUtils.executeWithChunk((IWorldReader)world, chunkPos, () -> activeChunks.add(pos));
        }
        if (!activeChunks.isEmpty()) {
            this.activeChunkMap.put(source, activeChunks);
        }
        for (BlockPos blockPos : chain.getLossMultipliers().keySet()) {
            sources = this.posToSourceMap.computeIfAbsent(blockPos, k -> new LinkedList());
            sources.add(source);
        }
        List sources2 = this.posToSourceMap.computeIfAbsent(sourcePos, k -> new LinkedList());
        sources2.add(source);
    }

    public Collection<TransmissionChain> getTransmissionChains() {
        return ImmutableList.copyOf(this.cachedSourceChain.values());
    }

    public void notifyTransmissionNodeChange(IPrismTransmissionNode node) {
        BlockPos pos = node.getLocationPos();
        List<IIndependentStarlightSource> sources = this.posToSourceMap.get(pos);
        if (sources != null) {
            new ArrayList<IIndependentStarlightSource>(sources).forEach(this::breakSourceNetwork);
        }
    }

    public TransmissionChain getSourceChain(IIndependentStarlightSource source) {
        return this.cachedSourceChain.get(source);
    }

    public void breakSourceNetwork(IIndependentStarlightSource source) {
        TransmissionChain knownChain = this.cachedSourceChain.get(source);
        if (knownChain != null) {
            List<IIndependentStarlightSource> sources;
            for (ChunkPos chPos : knownChain.getInvolvedChunks()) {
                sources = this.involvedSourceMap.get(chPos);
                if (sources == null) continue;
                sources.remove(source);
                if (!sources.isEmpty()) continue;
                this.involvedSourceMap.remove(chPos);
            }
            for (BlockPos pos : knownChain.getLossMultipliers().keySet()) {
                sources = this.posToSourceMap.get(pos);
                if (sources == null) continue;
                sources.remove(source);
                if (!sources.isEmpty()) continue;
                this.posToSourceMap.remove(pos);
            }
            SyncDataHolder.executeServer(SyncDataHolder.DATA_LIGHT_CONNECTIONS, DataLightConnections.class, data -> data.removeOldConnectionsThreaded(this.dimType, knownChain.getFoundConnections()));
            SyncDataHolder.executeServer(SyncDataHolder.DATA_LIGHT_BLOCK_ENDPOINTS, DataLightBlockEndpoints.class, data -> data.removeEndpoints(this.dimType, knownChain.getResolvedNormalBlockPositions()));
        }
        this.activeChunkMap.remove(source);
        this.cachedSourceChain.remove(source);
    }

    public void informChunkUnload(ChunkPos pos) {
        List<IIndependentStarlightSource> sources = this.involvedSourceMap.get(pos);
        if (sources != null) {
            for (IIndependentStarlightSource source : sources) {
                List<ChunkPos> activeChunks = this.activeChunkMap.get(source);
                if (activeChunks == null) continue;
                activeChunks.remove(pos);
                if (!activeChunks.isEmpty()) continue;
                this.activeChunkMap.remove(source);
            }
        }
    }

    public void informChunkLoad(ChunkPos pos) {
        List<IIndependentStarlightSource> sources = this.involvedSourceMap.get(pos);
        if (sources != null) {
            for (IIndependentStarlightSource source : sources) {
                List<Object> positions;
                TransmissionChain chain = this.cachedSourceChain.get(source);
                if (chain == null || !chain.getInvolvedChunks().contains(pos)) continue;
                if (this.activeChunkMap.containsKey(source)) {
                    positions = this.activeChunkMap.get(source);
                    if (positions.contains(pos)) continue;
                    positions.add(pos);
                    continue;
                }
                positions = new LinkedList<ChunkPos>();
                positions.add(pos);
                this.activeChunkMap.put(source, positions);
            }
        }
    }

    public void clear() {
        this.activeChunkMap.clear();
        this.cachedSourceChain.clear();
        this.involvedSourceMap.clear();
        this.posToSourceMap.clear();
    }
}

