/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.storage;

import hellfirepvp.astralsorcery.common.util.item.ItemComparator;
import hellfirepvp.astralsorcery.common.util.item.ItemUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public class StoredItemStack {
    private ItemStack stack;
    private int amount;

    StoredItemStack(ItemStack stack) {
        this(stack, stack.func_190916_E());
    }

    private StoredItemStack(ItemStack stack, int amount) {
        this.stack = ItemUtils.copyStackWithSize(stack, 1);
        this.amount = amount;
    }

    public ItemStack getTemplateStack() {
        return ItemUtils.copyStackWithSize(this.stack, Math.min(this.stack.func_77976_d(), this.amount));
    }

    public boolean removeAmount(int amount) {
        if (this.amount - amount < 0) {
            return false;
        }
        this.amount -= amount;
        return true;
    }

    public boolean isEmpty() {
        return this.amount <= 0;
    }

    public int getAmount() {
        return this.amount;
    }

    public boolean combineIntoThis(StoredItemStack other) {
        if (ItemComparator.compare(this.stack, other.stack, ItemComparator.Clause.Sets.ITEMSTACK_STRICT_NOAMOUNT)) {
            this.amount += other.amount;
            return true;
        }
        return false;
    }

    public boolean combineIntoThis(ItemStack other) {
        if (ItemComparator.compare(this.stack, other, ItemComparator.Clause.Sets.ITEMSTACK_STRICT_NOAMOUNT)) {
            this.amount += other.func_190916_E();
            return true;
        }
        return false;
    }

    @Nonnull
    public CompoundNBT serialize() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_218657_a("item", (INBT)this.stack.serializeNBT());
        tag.func_74768_a("amount", this.amount);
        return tag;
    }

    @Nullable
    public static StoredItemStack deserialize(CompoundNBT cmp) {
        ItemStack stack = ItemStack.func_199557_a((CompoundNBT)cmp.func_74775_l("item"));
        if (stack.func_190926_b()) {
            return null;
        }
        int amount = cmp.func_74762_e("amount");
        return new StoredItemStack(stack, amount);
    }
}

