/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile;

import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.VFXAlphaFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXScaleFunction;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXCube;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.client.util.ColorizationHelper;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.common.auxiliary.ChaliceHelper;
import hellfirepvp.astralsorcery.common.block.tile.BlockFountain;
import hellfirepvp.astralsorcery.common.crafting.recipe.LiquidInteraction;
import hellfirepvp.astralsorcery.common.crafting.recipe.LiquidInteractionContext;
import hellfirepvp.astralsorcery.common.fluid.FluidLiquidStarlight;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.lib.RecipeTypesAS;
import hellfirepvp.astralsorcery.common.lib.TileEntityTypesAS;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.play.server.PktPlayEffect;
import hellfirepvp.astralsorcery.common.tile.TileFountain;
import hellfirepvp.astralsorcery.common.tile.TileWell;
import hellfirepvp.astralsorcery.common.tile.base.TileEntityTick;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.RaytraceAssist;
import hellfirepvp.astralsorcery.common.util.block.BlockDiscoverer;
import hellfirepvp.astralsorcery.common.util.block.BlockPredicates;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.tile.FluidTankAccess;
import hellfirepvp.astralsorcery.common.util.tile.SimpleSingleFluidTank;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileChalice
extends TileEntityTick {
    private static final int TANK_SIZE = 64000;
    private final SimpleSingleFluidTank tank;
    private final FluidTankAccess access;
    private int nextInteraction = -1;
    private Vector3 rotation = new Vector3();
    private Vector3 prevRotation = new Vector3();
    private Vector3 rotationVec = null;

    public TileChalice() {
        super(TileEntityTypesAS.CHALICE);
        this.tank = new SimpleSingleFluidTank(64000);
        this.tank.addUpdateFunction(this::markForUpdate);
        this.access = new FluidTankAccess();
        this.access.putTank(0, (IFluidTank)this.tank, Direction.DOWN);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.func_145831_w().func_201670_d()) {
            if (this.rotationVec == null) {
                this.rotationVec = Vector3.random().normalize().multiply(1.5f);
            }
            this.prevRotation = this.rotation.clone();
            this.rotation.add(this.rotationVec);
        } else {
            if (this.nextInteraction == -1) {
                this.nextInteraction = this.ticksExisted + 20 + rand.nextInt(40);
            }
            if (this.ticksExisted < this.nextInteraction) {
                return;
            }
            this.nextInteraction = this.ticksExisted + 20 + rand.nextInt(40);
            if (!this.tickLightwellDraw() && !this.tickFountainDraw()) {
                this.tickChaliceInteractions();
            }
        }
    }

    private void tickChaliceInteractions() {
        if (this.func_145831_w().func_175640_z(this.field_174879_c) || this.func_145831_w().func_180495_p(this.func_174877_v().func_177977_b()).func_177230_c() instanceof BlockFountain) {
            return;
        }
        FluidStack thisFluid = this.getTank().getFluid();
        if (thisFluid.isEmpty()) {
            return;
        }
        List<BlockPos> chalicePositions = ChaliceHelper.findNearbyChalices(this.func_145831_w(), this.func_174877_v(), 16);
        Collections.shuffle(chalicePositions, rand);
        for (BlockPos otherChalicePos : chalicePositions) {
            FluidStack otherFluid;
            TileChalice otherChalice = MiscUtils.getTileAt((IBlockReader)this.func_145831_w(), otherChalicePos, TileChalice.class, false);
            if (otherChalice == null || (otherFluid = otherChalice.getTank().getFluid()).isEmpty()) continue;
            LiquidInteractionContext ctx = new LiquidInteractionContext(thisFluid, otherFluid);
            List<LiquidInteraction> recipes = RecipeTypesAS.TYPE_LIQUID_INTERACTION.findMatchingRecipes(ctx);
            LiquidInteraction recipe = LiquidInteraction.pickRecipe(recipes);
            while (recipe != null) {
                if (recipe.consumeInputs(this, otherChalice)) {
                    Vector3 thisChaliceV = new Vector3(this).add(0.5, 1.5, 0.5);
                    Vector3 otherChaliceV = new Vector3((Vec3i)otherChalicePos).add(0.5, 1.5, 0.5);
                    Vector3 target = thisChaliceV.getMidpoint(otherChaliceV);
                    recipe.getResult().doResult(this.func_145831_w(), target.clone());
                    PktPlayEffect pkt = new PktPlayEffect(PktPlayEffect.Type.LIQUID_INTERACTION_LINE).addData(buf -> {
                        ByteBufUtils.writeVector(buf, thisChaliceV);
                        ByteBufUtils.writeVector(buf, target);
                        ByteBufUtils.writeFluidStack(buf, thisFluid);
                        ByteBufUtils.writeVector(buf, otherChaliceV);
                        ByteBufUtils.writeVector(buf, target);
                        ByteBufUtils.writeFluidStack(buf, otherFluid);
                    });
                    PacketChannel.CHANNEL.sendToAllAround(pkt, PacketChannel.pointFromPos((IWorld)this.func_145831_w(), (Vec3i)target.toBlockPos(), 32.0));
                    return;
                }
                recipes.remove(recipe);
                recipe = LiquidInteraction.pickRecipe(recipes);
            }
        }
    }

    private boolean tickFountainDraw() {
        if (this.func_145831_w().func_175640_z(this.field_174879_c)) {
            return false;
        }
        Vector3 thisVector = new Vector3(this).add(0.5, 1.5, 0.5);
        List<BlockPos> fountains = BlockDiscoverer.searchForBlocksAround(this.field_145850_b, this.field_174879_c, 16, BlockPredicates.isBlock(new Block[]{BlocksAS.FOUNTAIN}));
        fountains.removeIf(pos -> {
            Vector3 fountainVec = new Vector3((Vec3i)pos).add(0.5, 0.5, 0.5);
            RaytraceAssist assist = new RaytraceAssist(thisVector, fountainVec);
            return !assist.isClear(this.field_145850_b);
        });
        Collections.shuffle(fountains, rand);
        for (BlockPos wellPos : fountains) {
            int maxFillable;
            FluidStack drained;
            TileFountain fountain = MiscUtils.getTileAt((IBlockReader)this.field_145850_b, wellPos, TileFountain.class, true);
            if (fountain == null || (drained = fountain.getTank().drain(400, IFluidHandler.FluidAction.SIMULATE)).getAmount() <= 100 || (maxFillable = this.getTank().fill(drained, IFluidHandler.FluidAction.SIMULATE)) <= 0) continue;
            FluidStack actual = fountain.getTank().drain(new FluidStack(drained, maxFillable), IFluidHandler.FluidAction.EXECUTE);
            this.getTank().fill(actual, IFluidHandler.FluidAction.EXECUTE);
            Vector3 wellVec = new Vector3((Vec3i)wellPos).add(0.5, 0.5, 0.5);
            PktPlayEffect pkt = new PktPlayEffect(PktPlayEffect.Type.LIQUID_INTERACTION_LINE).addData(buf -> {
                ByteBufUtils.writeVector(buf, wellVec);
                ByteBufUtils.writeVector(buf, thisVector);
                ByteBufUtils.writeFluidStack(buf, actual);
            });
            PacketChannel.CHANNEL.sendToAllAround(pkt, PacketChannel.pointFromPos((IWorld)this.func_145831_w(), (Vec3i)wellVec.toBlockPos(), 32.0));
            return true;
        }
        return false;
    }

    private boolean tickLightwellDraw() {
        if (this.func_145831_w().func_175640_z(this.field_174879_c)) {
            return false;
        }
        FluidStack thisFluid = this.getTank().getFluid();
        if (!(thisFluid.isEmpty() || thisFluid.getFluid() instanceof FluidLiquidStarlight && thisFluid.getAmount() + 100 < 64000)) {
            return false;
        }
        Vector3 thisVector = new Vector3(this).add(0.5, 1.5, 0.5);
        List<BlockPos> wellPositions = BlockDiscoverer.searchForBlocksAround(this.field_145850_b, this.field_174879_c, 16, BlockPredicates.isBlock(new Block[]{BlocksAS.WELL}));
        wellPositions.removeIf(pos -> {
            Vector3 wellVec = new Vector3((Vec3i)pos).add(0.5, 0.5, 0.5);
            RaytraceAssist assist = new RaytraceAssist(thisVector, wellVec);
            return !assist.isClear(this.field_145850_b);
        });
        Collections.shuffle(wellPositions, rand);
        for (BlockPos wellPos : wellPositions) {
            FluidStack drained;
            TileWell well = MiscUtils.getTileAt((IBlockReader)this.field_145850_b, wellPos, TileWell.class, true);
            if (well == null || !((drained = well.getTank().drain(400, IFluidHandler.FluidAction.SIMULATE)).getFluid() instanceof FluidLiquidStarlight) || drained.getAmount() <= 100) continue;
            int maxFillable = this.getTank().getMaxAddable(drained.getAmount());
            if (maxFillable > 0) {
                FluidStack actual = well.getTank().drain(new FluidStack(drained, maxFillable), IFluidHandler.FluidAction.EXECUTE);
                this.getTank().fill(actual, IFluidHandler.FluidAction.EXECUTE);
                Vector3 wellVec = new Vector3((Vec3i)wellPos).add(0.5, 0.5, 0.5);
                PktPlayEffect pkt = new PktPlayEffect(PktPlayEffect.Type.LIQUID_INTERACTION_LINE).addData(buf -> {
                    ByteBufUtils.writeVector(buf, wellVec);
                    ByteBufUtils.writeVector(buf, thisVector);
                    ByteBufUtils.writeFluidStack(buf, actual);
                });
                PacketChannel.CHANNEL.sendToAllAround(pkt, PacketChannel.pointFromPos((IWorld)this.func_145831_w(), (Vec3i)wellVec.toBlockPos(), 32.0));
                return true;
            }
            return false;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawLiquidLine(PktPlayEffect pktPlayEffect) {
        PacketBuffer buf = pktPlayEffect.getExtraData();
        while (buf.isReadable()) {
            Vector3 from = ByteBufUtils.readVector(pktPlayEffect.getExtraData());
            Vector3 to = ByteBufUtils.readVector(pktPlayEffect.getExtraData());
            FluidStack fluid = ByteBufUtils.readFluidStack(pktPlayEffect.getExtraData());
            VFXColorFunction colorFn = VFXColorFunction.constant(ColorizationHelper.getColor(fluid).orElse(Color.WHITE).brighter());
            TileChalice.playLineGenericParticles(from, to, 0.1f + rand.nextFloat() * 0.2f, colorFn);
            TileChalice.playLineGenericParticles(from, to, 0.1f + rand.nextFloat() * 0.2f, colorFn);
            TileChalice.playLineFluidParticles(from, to, 0.25f + rand.nextFloat() * 0.2f, fluid);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void playLineGenericParticles(Vector3 from, Vector3 to, float width, VFXColorFunction<?> colorFn) {
        TileChalice.playLineParticles(from, to, width, at -> (EntityVisualFX)((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn((Vector3)at)).color(colorFn)).alpha(VFXAlphaFunction.FADE_OUT)).setMotion(Vector3.random().multiply(0.01f))).setScaleMultiplier(0.15f + rand.nextFloat() * 0.25f)).setMaxAge(20 + rand.nextInt(35)));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void playLineFluidParticles(Vector3 from, Vector3 to, float width, FluidStack fluid) {
        Color c = new Color(fluid.getFluid().getAttributes().getColor(fluid));
        TileChalice.playLineParticles(from, to, width, at -> (EntityVisualFX)((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXCube)EffectHelper.of(EffectTemplatesAS.CUBE_TRANSLUCENT_ATLAS).spawn((Vector3)at)).setTextureAtlasSprite(RenderingUtils.getParticleTexture(fluid)).tumble().color(VFXColorFunction.constant(c))).setMotion(Vector3.random().multiply(0.01f))).setScaleMultiplier(0.2f + rand.nextFloat() * 0.05f)).scale(VFXScaleFunction.SHRINK)).setMaxAge(10 + rand.nextInt(15)));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void playLineParticles(Vector3 from, Vector3 to, float width, Function<Vector3, EntityVisualFX> pCreator) {
        to.clone().subtract(from).stepAlongVector(width, v -> {
            EntityVisualFX cfr_ignored_0 = (EntityVisualFX)pCreator.apply(from.clone().add((Vector3)v));
        });
    }

    @Nonnull
    public SimpleSingleFluidTank getTank() {
        return this.tank;
    }

    @Nonnull
    public IFluidHandler getTankAccess() {
        return (IFluidHandler)this.access.getCapability(Direction.DOWN).orElse(null);
    }

    @Nonnull
    public Vector3 getRotation() {
        return this.rotation;
    }

    @Nonnull
    public Vector3 getPrevRotation() {
        return this.prevRotation;
    }

    @Override
    public void readCustomNBT(CompoundNBT compound) {
        super.readCustomNBT(compound);
        this.tank.readNBT(compound.func_74775_l("tank"));
    }

    @Override
    public void writeCustomNBT(CompoundNBT compound) {
        super.writeCustomNBT(compound);
        compound.func_218657_a("tank", (INBT)this.tank.writeNBT());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (this.access.hasCapability(cap, side)) {
            return this.access.getCapability(side).cast();
        }
        return super.getCapability(cap, side);
    }
}

