/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile;

import hellfirepvp.astralsorcery.common.block.tile.fountain.BlockFountainPrime;
import hellfirepvp.astralsorcery.common.crafting.nojson.FountainEffectRegistry;
import hellfirepvp.astralsorcery.common.crafting.nojson.fountain.FountainEffect;
import hellfirepvp.astralsorcery.common.fluid.FluidLiquidStarlight;
import hellfirepvp.astralsorcery.common.lib.StructureTypesAS;
import hellfirepvp.astralsorcery.common.lib.TileEntityTypesAS;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.play.server.PktPlayEffect;
import hellfirepvp.astralsorcery.common.structure.types.StructureType;
import hellfirepvp.astralsorcery.common.tile.TileChalice;
import hellfirepvp.astralsorcery.common.tile.base.TileEntityTick;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import hellfirepvp.astralsorcery.common.util.tile.FluidTankAccess;
import hellfirepvp.astralsorcery.common.util.tile.SimpleSingleFluidTank;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.LogicalSide;

public class TileFountain
extends TileEntityTick {
    private static final int TANK_SIZE = 16000;
    private static final int LIQUID_STARLIGHT_TANK_SIZE = 16000;
    private FountainEffect<?> currentEffect;
    private FountainEffect.EffectContext effectContext;
    private int tickDrawLiquidStarlight = 0;
    private int tickActiveFountainEffect = 0;
    private int mbLiquidStarlight = 0;
    private final FluidTankAccess access;
    private final SimpleSingleFluidTank tank = new SimpleSingleFluidTank(16000);

    public TileFountain() {
        super(TileEntityTypesAS.FOUNTAIN);
        this.tank.addUpdateFunction(this::markForUpdate);
        this.access = new FluidTankAccess();
        this.access.putTank(0, (IFluidTank)this.tank, new Direction[0]);
    }

    @Override
    public void func_73660_a() {
        FountainEffect<?> effect;
        super.func_73660_a();
        if (!this.func_145831_w().func_201670_d()) {
            if (this.hasMultiblock()) {
                this.updateFountainComponents();
                this.drawLiquidStarlight();
                FountainEffect<?> effect2 = this.getCurrentEffect();
                if (effect2 != null) {
                    FountainEffect.OperationSegment nextSegment;
                    FountainEffect.EffectContext ctx = this.effectContext;
                    if (!this.consumeLiquidStarlight(1)) {
                        this.setCurrentEffect(null);
                        this.replaceCurrentEffect(effect2, ctx, null);
                        return;
                    }
                    FountainEffect.OperationSegment segment = this.getSegment();
                    if (segment != FountainEffect.OperationSegment.RUNNING) {
                        ++this.tickActiveFountainEffect;
                    }
                    if (segment != (nextSegment = this.getSegment())) {
                        effect2.transition(this, ctx, LogicalSide.SERVER, segment, nextSegment);
                        PktPlayEffect pkt = new PktPlayEffect(PktPlayEffect.Type.FOUNTAIN_TRANSITION_SEGMENT).addData(buf -> {
                            ByteBufUtils.writePos(buf, this.field_174879_c);
                            ByteBufUtils.writeEnumValue(buf, segment);
                            ByteBufUtils.writeEnumValue(buf, nextSegment);
                        });
                        PacketChannel.CHANNEL.sendToAllAround(pkt, PacketChannel.pointFromPos((IWorld)this.field_145850_b, (Vec3i)this.field_174879_c, 32.0));
                    }
                    effect2.tick(this, ctx, this.tickActiveFountainEffect, LogicalSide.SERVER, this.getSegment());
                }
            }
        } else if (this.hasMultiblock() && (effect = this.getCurrentEffect()) != null) {
            effect.tick(this, this.effectContext, this.tickActiveFountainEffect, LogicalSide.CLIENT, this.getSegment());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void playTransitionEffect(PktPlayEffect pktPlayEffect) {
        BlockPos at = ByteBufUtils.readPos(pktPlayEffect.getExtraData());
        FountainEffect.OperationSegment segment = ByteBufUtils.readEnumValue(pktPlayEffect.getExtraData(), FountainEffect.OperationSegment.class);
        FountainEffect.OperationSegment nextSegment = ByteBufUtils.readEnumValue(pktPlayEffect.getExtraData(), FountainEffect.OperationSegment.class);
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return;
        }
        TileFountain fountain = MiscUtils.getTileAt((IBlockReader)world, at, TileFountain.class, false);
        if (fountain == null) {
            return;
        }
        FountainEffect<?> effect = fountain.getCurrentEffect();
        if (effect == null) {
            return;
        }
        effect.transition(fountain, fountain.effectContext, LogicalSide.CLIENT, segment, nextSegment);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void replaceEffect(PktPlayEffect pktPlayEffect) {
        BlockPos at = ByteBufUtils.readPos(pktPlayEffect.getExtraData());
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return;
        }
        TileFountain fountain = MiscUtils.getTileAt((IBlockReader)world, at, TileFountain.class, false);
        if (fountain == null) {
            return;
        }
        FountainEffect<?> effect = fountain.getCurrentEffect();
        if (effect == null) {
            return;
        }
        effect.onReplace(fountain, fountain.effectContext, null, LogicalSide.CLIENT);
    }

    private void drawLiquidStarlight() {
        --this.tickDrawLiquidStarlight;
        if (this.tickDrawLiquidStarlight <= 0) {
            FluidStack fluid;
            TileChalice chalice;
            this.tickDrawLiquidStarlight = 100;
            if ((float)this.mbLiquidStarlight < 12800.0f && this.currentEffect != null && (chalice = MiscUtils.getTileAt((IBlockReader)this.field_145850_b, this.field_174879_c.func_177984_a(), TileChalice.class, false)) != null && !(fluid = chalice.getTank().drain(400, IFluidHandler.FluidAction.SIMULATE)).isEmpty() && fluid.getFluid() instanceof FluidLiquidStarlight) {
                FluidStack drained = chalice.getTank().drain(new FluidStack(fluid, 400), IFluidHandler.FluidAction.EXECUTE);
                this.mbLiquidStarlight += drained.getAmount();
                this.markForUpdate();
            }
        }
    }

    private void updateFountainComponents() {
        FountainEffect<?> prevEffect = this.getCurrentEffect();
        FountainEffect.EffectContext prevContext = this.effectContext;
        BlockState primeState = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b());
        if (primeState.func_177230_c() instanceof BlockFountainPrime) {
            if (this.setCurrentEffect(((BlockFountainPrime)primeState.func_177230_c()).provideEffect()) && prevEffect != null) {
                this.replaceCurrentEffect(prevEffect, prevContext, this.getCurrentEffect());
            }
        } else if (this.setCurrentEffect(null) && prevEffect != null) {
            this.replaceCurrentEffect(prevEffect, prevContext, null);
        }
    }

    private void replaceCurrentEffect(FountainEffect prevEffect, FountainEffect.EffectContext prevContext, FountainEffect newEffect) {
        prevEffect.onReplace(this, prevContext, newEffect, LogicalSide.SERVER);
        PktPlayEffect pkt = new PktPlayEffect(PktPlayEffect.Type.FOUNTAIN_REPLACE_EFFECT).addData(buf -> ByteBufUtils.writePos(buf, this.field_174879_c));
        PacketChannel.CHANNEL.sendToAllAround(pkt, PacketChannel.pointFromPos((IWorld)this.field_145850_b, (Vec3i)this.field_174879_c, 32.0));
    }

    private boolean setCurrentEffect(@Nullable FountainEffect<?> effect) {
        if (!Objects.equals(this.currentEffect, effect)) {
            this.tickActiveFountainEffect = 0;
            this.currentEffect = effect;
            this.effectContext = this.currentEffect == null ? null : this.currentEffect.createContext(this);
            this.markForUpdate();
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public StructureType getRequiredStructureType() {
        return StructureTypesAS.PTYPE_FOUNTAIN;
    }

    public boolean consumeLiquidStarlight(int amount) {
        if (amount <= 0) {
            return this.mbLiquidStarlight > 0;
        }
        if (this.mbLiquidStarlight >= amount) {
            this.mbLiquidStarlight -= amount;
            this.markForUpdate();
            return true;
        }
        this.mbLiquidStarlight = 0;
        this.markForUpdate();
        return false;
    }

    public FountainEffect.OperationSegment getSegment() {
        if (this.getCurrentEffect() == null || this.tickActiveFountainEffect == 0) {
            return FountainEffect.OperationSegment.INACTIVE;
        }
        if (this.getCurrentEffect().isInTick(FountainEffect.OperationSegment.STARTUP, this.tickActiveFountainEffect)) {
            return FountainEffect.OperationSegment.STARTUP;
        }
        if (this.getCurrentEffect().isInTick(FountainEffect.OperationSegment.PREPARATION, this.tickActiveFountainEffect)) {
            return FountainEffect.OperationSegment.PREPARATION;
        }
        return FountainEffect.OperationSegment.RUNNING;
    }

    @Nullable
    public FountainEffect<?> getCurrentEffect() {
        return this.currentEffect;
    }

    public int getTickActiveFountainEffect() {
        return this.tickActiveFountainEffect;
    }

    @Nonnull
    public SimpleSingleFluidTank getTank() {
        return this.tank;
    }

    @Override
    public void readCustomNBT(CompoundNBT compound) {
        super.readCustomNBT(compound);
        this.tickActiveFountainEffect = compound.func_74762_e("tickActiveFountainEffect");
        this.mbLiquidStarlight = compound.func_74762_e("mbLiquidStarlight");
        this.tank.readNBT(compound.func_74775_l("tank"));
        if (compound.func_74764_b("currentEffect")) {
            FountainEffect<?> prevEffect = this.getCurrentEffect();
            ResourceLocation key = new ResourceLocation(compound.func_74779_i("currentEffect"));
            this.currentEffect = FountainEffectRegistry.getEffect(key);
            if (this.currentEffect != null) {
                if (!Objects.equals(this.currentEffect, prevEffect)) {
                    this.effectContext = this.currentEffect.createContext(this);
                }
                this.effectContext.readFromNBT(compound.func_74775_l("currentEffectData"));
            } else {
                this.effectContext = null;
            }
        } else {
            this.currentEffect = null;
            this.effectContext = null;
        }
    }

    @Override
    public void writeCustomNBT(CompoundNBT compound) {
        super.writeCustomNBT(compound);
        compound.func_74768_a("tickActiveFountainEffect", this.tickActiveFountainEffect);
        compound.func_74768_a("mbLiquidStarlight", this.mbLiquidStarlight);
        compound.func_218657_a("tank", (INBT)this.tank.writeNBT());
        if (this.currentEffect != null) {
            compound.func_74778_a("currentEffect", this.currentEffect.getId().toString());
            if (this.effectContext != null) {
                CompoundNBT tag = new CompoundNBT();
                this.effectContext.writeToNBT(tag);
                compound.func_218657_a("currentEffectData", (INBT)tag);
            }
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (this.access.hasCapability(cap, side)) {
            return this.access.getCapability(side).cast();
        }
        return super.getCapability(cap, side);
    }
}

