/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile;

import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.VFXAlphaFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.common.constellation.world.DayTimeHelper;
import hellfirepvp.astralsorcery.common.crafting.recipe.WellLiquefaction;
import hellfirepvp.astralsorcery.common.crafting.recipe.WellLiquefactionContext;
import hellfirepvp.astralsorcery.common.crystal.CrystalAttributeItem;
import hellfirepvp.astralsorcery.common.crystal.CrystalAttributes;
import hellfirepvp.astralsorcery.common.entity.EntityFlare;
import hellfirepvp.astralsorcery.common.fluid.BlockLiquidStarlight;
import hellfirepvp.astralsorcery.common.fluid.FluidLiquidStarlight;
import hellfirepvp.astralsorcery.common.lib.RecipeTypesAS;
import hellfirepvp.astralsorcery.common.lib.TileEntityTypesAS;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.play.server.PktPlayEffect;
import hellfirepvp.astralsorcery.common.tile.base.TileEntitySynchronized;
import hellfirepvp.astralsorcery.common.tile.base.network.TileReceiverBase;
import hellfirepvp.astralsorcery.common.tile.network.StarlightReceiverWell;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.sound.SoundHelper;
import hellfirepvp.astralsorcery.common.util.tile.FluidTankAccess;
import hellfirepvp.astralsorcery.common.util.tile.PrecisionSingleFluidTank;
import hellfirepvp.astralsorcery.common.util.tile.TileInventoryFiltered;
import hellfirepvp.astralsorcery.common.util.world.SkyCollectionHelper;
import java.awt.Color;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.IFluidTank;

public class TileWell
extends TileReceiverBase<StarlightReceiverWell> {
    private static final int TANK_SIZE = 2000;
    private WellLiquefaction runningRecipe = null;
    private FluidTankAccess access;
    private PrecisionSingleFluidTank tank = new PrecisionSingleFluidTank(2000);
    private TileInventoryFiltered inventory;
    private double starlightBuffer = 0.0;
    private float posDistribution = -1.0f;

    public TileWell() {
        super(TileEntityTypesAS.WELL);
        this.tank.setAllowInput(false);
        this.tank.addUpdateFunction(this::markForUpdate);
        this.access = new FluidTankAccess();
        this.access.putTank(0, (IFluidTank)this.tank, Direction.DOWN);
        this.inventory = new TileInventoryFiltered((TileEntitySynchronized)this, () -> 1, Direction.DOWN);
        this.inventory.canExtract((slot, amount, existing) -> false);
        this.inventory.canInsert((slot, toAdd, existing) -> {
            if (toAdd.func_190926_b()) {
                return true;
            }
            return existing.func_190926_b() && RecipeTypesAS.TYPE_WELL.findRecipe(new WellLiquefactionContext(toAdd)) != null;
        });
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.func_145831_w().func_201670_d()) {
            ItemStack stack;
            if (this.doesSeeSky()) {
                this.collectStarlight();
            }
            if (!(stack = this.getInventory().getStackInSlot(0)).func_190926_b()) {
                if (!this.func_145831_w().func_175623_d(this.func_174877_v().func_177984_a())) {
                    this.breakCatalyst();
                } else {
                    if (this.runningRecipe == null) {
                        this.runningRecipe = RecipeTypesAS.TYPE_WELL.findRecipe(new WellLiquefactionContext(this));
                    }
                    if (this.runningRecipe != null) {
                        double gain;
                        CrystalAttributes attributes;
                        int statMultiplier = 1;
                        if (stack.func_77973_b() instanceof CrystalAttributeItem && (attributes = ((CrystalAttributeItem)stack.func_77973_b()).getAttributes(stack)) != null) {
                            statMultiplier = attributes.getTotalTierLevel();
                        }
                        if ((gain = Math.sqrt(this.starlightBuffer) * (double)((float)statMultiplier * this.runningRecipe.getProductionMultiplier())) > 0.0 && this.tank.getFluidAmount() <= 2000) {
                            this.fillAndDiscardRest(this.runningRecipe, gain);
                            if (rand.nextInt(750) == 0) {
                                EntityFlare.spawnAmbientFlare(this.func_145831_w(), this.func_174877_v().func_177982_a(-3 + rand.nextInt(7), 1, -3 + rand.nextInt(7)));
                            }
                        }
                        this.starlightBuffer = 0.0;
                        if (rand.nextInt(1 + (int)(1000.0f * ((float)statMultiplier * this.runningRecipe.getShatterMultiplier()))) == 0) {
                            this.breakCatalyst();
                            EntityFlare.spawnAmbientFlare(this.func_145831_w(), this.func_174877_v().func_177982_a(-3 + rand.nextInt(7), 1, -3 + rand.nextInt(7)));
                        }
                    } else {
                        this.breakCatalyst();
                    }
                }
            }
            this.starlightBuffer = 0.0;
        } else {
            this.doClientEffects();
        }
    }

    private void fillAndDiscardRest(WellLiquefaction recipe, double gain) {
        Fluid produced = recipe.getFluidOutput();
        if (produced == null) {
            return;
        }
        if (this.tank.getFluidAmount() < 10) {
            this.tank.setFluid(produced);
        }
        if (this.tank.getFluid().isEmpty()) {
            this.tank.setFluid(produced);
        } else if (!produced.equals(this.tank.getFluid().getFluid())) {
            return;
        }
        this.tank.addAmount(gain);
    }

    public void breakCatalyst() {
        this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
        this.runningRecipe = null;
        PktPlayEffect effect = new PktPlayEffect(PktPlayEffect.Type.SMALL_CRYSTAL_BREAK).addData(buf -> ByteBufUtils.writeVector(buf, new Vector3(this).add(0.5, 1.3, 0.5)));
        PacketChannel.CHANNEL.sendToAllAround(effect, PacketChannel.pointFromPos((IWorld)this.func_145831_w(), (Vec3i)this.func_174877_v(), 32.0));
        SoundHelper.playSoundAround(SoundEvents.field_187561_bM, this.func_145831_w(), (Vec3i)this.func_174877_v(), 1.0f, 1.0f);
        this.markForUpdate();
    }

    @Nonnull
    public ItemStack getCatalyst() {
        return this.getInventory().getStackInSlot(0);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void doClientEffects() {
        ItemStack stack = this.inventory.getStackInSlot(0);
        if (!stack.func_190926_b()) {
            this.runningRecipe = RecipeTypesAS.TYPE_WELL.findRecipe(new WellLiquefactionContext(this));
            if (this.runningRecipe != null) {
                Color color = Color.WHITE;
                if (this.runningRecipe.getCatalystColor() != null) {
                    color = this.runningRecipe.getCatalystColor();
                }
                this.doCatalystEffect(color);
            }
        }
        if (this.tank.getFluidAmount() > 0 && this.tank.getFluid().getFluid() instanceof FluidLiquidStarlight) {
            BlockLiquidStarlight.playLiquidStarlightBlockEffect(rand, new Vector3(this).add(0.0, 0.4 + (double)this.tank.getPercentageFilled() * 0.5, 0.0), 0.7f);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void doCatalystEffect(Color color) {
        if (rand.nextInt(6) == 0) {
            Vector3 at = new Vector3(this).add(0.5, 1.0, 0.5).add((double)rand.nextFloat() * 0.15 * (double)(rand.nextBoolean() ? 1 : -1), (double)rand.nextFloat() * 0.2, (double)rand.nextFloat() * 0.15 * (double)(rand.nextBoolean() ? 1 : -1));
            ((EntityComplexFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(at)).alpha(VFXAlphaFunction.FADE_OUT)).color(VFXColorFunction.constant(color))).setMaxAge(25 + rand.nextInt(20));
        }
    }

    private void collectStarlight() {
        double sbDayDistribution = DayTimeHelper.getCurrentDaytimeDistribution(this.field_145850_b);
        sbDayDistribution = 0.3 + 0.7 * sbDayDistribution;
        int yLevel = this.func_174877_v().func_177956_o();
        float dstr = yLevel > 120 ? 1.0f : (float)yLevel / 120.0f;
        if (this.posDistribution == -1.0f) {
            this.posDistribution = SkyCollectionHelper.getSkyNoiseDistribution(this.field_145850_b, this.func_174877_v());
        }
        sbDayDistribution *= (double)dstr;
        this.starlightBuffer += Math.max(1.0E-4, sbDayDistribution *= 1.0 + 1.2 * (double)this.posDistribution);
    }

    public void receiveStarlight(double amount) {
        this.starlightBuffer += amount;
        this.markForUpdate();
    }

    @Nonnull
    public PrecisionSingleFluidTank getTank() {
        return this.tank;
    }

    @Nonnull
    public TileInventoryFiltered getInventory() {
        return this.inventory;
    }

    @Override
    @Nonnull
    public StarlightReceiverWell provideEndpoint(BlockPos at) {
        return new StarlightReceiverWell(at);
    }

    @Override
    public void readCustomNBT(CompoundNBT compound) {
        super.readCustomNBT(compound);
        this.tank.readNBT(compound.func_74775_l("tank"));
        this.inventory = this.inventory.deserialize(compound.func_74775_l("inventory"));
    }

    @Override
    public void writeCustomNBT(CompoundNBT compound) {
        super.writeCustomNBT(compound);
        compound.func_218657_a("tank", (INBT)this.tank.writeNBT());
        compound.func_218657_a("inventory", (INBT)this.inventory.serialize());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (this.access.hasCapability(cap, side)) {
            return this.access.getCapability(side).cast();
        }
        if (this.inventory.hasCapability(cap, side)) {
            return this.inventory.getCapability().cast();
        }
        return super.getCapability(cap, side);
    }
}

