/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class IngredientHelper {
    @OnlyIn(value=Dist.CLIENT)
    public static ItemStack getRandomVisibleStack(Ingredient ingredient) {
        return IngredientHelper.getRandomVisibleStack(ingredient, 0L);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static ItemStack getRandomVisibleStack(Ingredient ingredient, long tick) {
        List<ItemStack> applicable = IngredientHelper.getVisibleItemStacks(ingredient);
        if (applicable.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        int mod = (int)(tick / 20L % (long)applicable.size());
        return applicable.get(MathHelper.func_76125_a((int)mod, (int)0, (int)(applicable.size() - 1)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static List<ItemStack> getVisibleItemStacks(Ingredient ingredient) {
        if (ingredient.func_203189_d()) {
            return Collections.emptyList();
        }
        return Arrays.asList(ingredient.func_193365_a());
    }

    @Nullable
    public static Tag<Item> guessTag(Ingredient ingredient) {
        ItemStack[] stacks = ingredient.func_193365_a();
        if (stacks.length == 0) {
            return null;
        }
        ArrayList<ItemTags.Wrapper> applicableTags = new ArrayList<ItemTags.Wrapper>();
        ItemStack first = stacks[0];
        for (ResourceLocation key : first.func_77973_b().getTags()) {
            ItemTags.Wrapper wrapper = new ItemTags.Wrapper(key);
            boolean containsAllItems = true;
            for (Item itemInTag : wrapper.func_199885_a()) {
                if (ingredient.test(new ItemStack((IItemProvider)itemInTag))) continue;
                containsAllItems = false;
                break;
            }
            if (!containsAllItems) continue;
            applicableTags.add(wrapper);
        }
        return applicableTags.stream().max(Comparator.comparingInt(tag -> tag.func_199885_a().size())).orElse(null);
    }
}

