/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.BiomeDictionary;

public class StructureFinder {
    private StructureFinder() {
    }

    @Nullable
    public static BlockPos tryFindClosestStructure(ServerWorld world, BlockPos playerPos, Structure<?> structure, int searchRadius) {
        ChunkGenerator gen = world.func_72863_F().func_201711_g();
        try {
            return structure.func_211405_a((World)world, gen, playerPos, searchRadius, true);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    @Nullable
    public static BlockPos tryFindClosestBiomeType(ServerWorld world, BlockPos playerPos, BiomeDictionary.Type biomeType, int searchRadius) {
        ArrayList fitting = Lists.newArrayList((Iterable)BiomeDictionary.getBiomes((BiomeDictionary.Type)biomeType));
        if (fitting.isEmpty()) {
            return null;
        }
        BiomeProvider gen = world.func_72863_F().func_201711_g().func_202090_b();
        for (int reach = 64; reach < searchRadius; reach += 128) {
            BlockPos closest = gen.func_225531_a_(playerPos.func_177958_n(), playerPos.func_177956_o(), playerPos.func_177952_p(), reach, (List)fitting, new Random(world.func_72905_C()));
            if (closest == null) continue;
            return closest;
        }
        return null;
    }
}

