/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util.block;

import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.block.BlockPredicate;
import java.util.Arrays;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.Tag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;

public class BlockPredicates {
    public static BlockPredicate isInTag(Tag<Block> blockTag) {
        return (world, pos, state) -> state.func_203425_a(blockTag);
    }

    public static BlockPredicate isBlock(Block ... blocks) {
        HashSet<Block> applicable = new HashSet<Block>(Arrays.asList(blocks));
        return (world, pos, state) -> applicable.contains(state.func_177230_c());
    }

    public static BlockPredicate isState(BlockState ... states) {
        HashSet<BlockState> applicable = new HashSet<BlockState>(Arrays.asList(states));
        return (world, pos, state) -> applicable.contains(state);
    }

    public static <T extends TileEntity> BlockPredicate doesTileExist(T tile, boolean loadTileWorldAndChunk) {
        DimensionType dimType = tile.func_145831_w().func_201675_m().func_186058_p();
        TileEntityType tileType = tile.func_200662_C();
        MinecraftServer srv = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
        return (world, pos, state) -> {
            if (loadTileWorldAndChunk || srv.forgeGetWorldMap().containsKey(dimType)) {
                ServerWorld foundWorld = srv.func_71218_a(dimType);
                if (!loadTileWorldAndChunk && !foundWorld.func_72863_F().func_222865_a(new ChunkPos(pos))) {
                    return true;
                }
                TileEntity te = MiscUtils.getTileAt((IBlockReader)foundWorld, pos, TileEntity.class, true);
                return te != null && te.func_200662_C().equals(tileType);
            }
            return true;
        };
    }
}

