/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util.dispenser;

import hellfirepvp.astralsorcery.AstralSorcery;
import javax.annotation.Nonnull;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.DispenserTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidContainerDispenseBehavior
extends DefaultDispenseItemBehavior {
    private static final FluidContainerDispenseBehavior INSTANCE = new FluidContainerDispenseBehavior();
    private final DefaultDispenseItemBehavior defaultBehavior = new DefaultDispenseItemBehavior();

    private FluidContainerDispenseBehavior() {
    }

    public static FluidContainerDispenseBehavior getInstance() {
        return INSTANCE;
    }

    protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
        if (FluidUtil.getFluidContained((ItemStack)stack).isPresent()) {
            return this.dumpContainer(source, stack);
        }
        return this.fillContainer(source, stack);
    }

    @Nonnull
    private ItemStack fillContainer(IBlockSource source, ItemStack stack) {
        World world = source.func_197524_h();
        Direction dispenserFacing = (Direction)source.func_189992_e().func_177229_b((IProperty)DispenserBlock.field_176441_a);
        BlockPos blockpos = source.func_180699_d().func_177972_a(dispenserFacing);
        FluidActionResult actionResult = FluidUtil.tryPickUpFluid((ItemStack)stack, null, (World)world, (BlockPos)blockpos, (Direction)dispenserFacing.func_176734_d());
        ItemStack resultStack = actionResult.getResult();
        if (!actionResult.isSuccess() || resultStack.func_190926_b()) {
            return super.func_82487_b(source, stack);
        }
        if (stack.func_190916_E() == 1) {
            return resultStack;
        }
        if (((DispenserTileEntity)source.func_150835_j()).func_146019_a(resultStack) < 0) {
            this.defaultBehavior.dispense(source, resultStack);
        }
        ItemStack stackCopy = stack.func_77946_l();
        stackCopy.func_190918_g(1);
        return stackCopy;
    }

    @Nonnull
    private ItemStack dumpContainer(IBlockSource source, @Nonnull ItemStack stack) {
        World world = source.func_197524_h();
        if (!(world instanceof ServerWorld)) {
            return super.func_82487_b(source, stack);
        }
        ItemStack singleStack = stack.func_77946_l();
        singleStack.func_190920_e(1);
        LazyOptional itemFluidHandler = FluidUtil.getFluidHandler((ItemStack)singleStack);
        if (!itemFluidHandler.isPresent()) {
            return super.func_82487_b(source, stack);
        }
        FluidStack drained = (FluidStack)itemFluidHandler.map(handler -> handler.drain(1000, IFluidHandler.FluidAction.EXECUTE)).orElse((Object)FluidStack.EMPTY);
        Direction dispenserFacing = (Direction)source.func_189992_e().func_177229_b((IProperty)DispenserBlock.field_176441_a);
        BlockPos pos = source.func_180699_d().func_177972_a(dispenserFacing);
        FakePlayer player = AstralSorcery.getProxy().getASFakePlayerServer((ServerWorld)world);
        FluidActionResult result = FluidUtil.tryPlaceFluid((PlayerEntity)player, (World)source.func_197524_h(), (Hand)Hand.MAIN_HAND, (BlockPos)pos, (ItemStack)stack, (FluidStack)drained);
        if (result.isSuccess()) {
            ItemStack drainedStack = result.getResult();
            if (drainedStack.func_190916_E() == 1) {
                return drainedStack;
            }
            if (!drainedStack.func_190926_b() && ((DispenserTileEntity)source.func_150835_j()).func_146019_a(drainedStack) < 0) {
                this.defaultBehavior.dispense(source, drainedStack);
            }
            ItemStack stackCopy = drainedStack.func_77946_l();
            stackCopy.func_190918_g(1);
            return stackCopy;
        }
        return this.defaultBehavior.dispense(source, stack);
    }
}

