/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util.nbt;

import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.IProperty;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;

public class NBTHelper {
    @Nonnull
    public static CompoundNBT getPersistentData(Entity entity) {
        return NBTHelper.getPersistentData(entity.getPersistentData());
    }

    @Nonnull
    public static CompoundNBT getPersistentData(ItemStack item) {
        return NBTHelper.getPersistentData(NBTHelper.getData(item));
    }

    @Nonnull
    public static CompoundNBT getPersistentData(CompoundNBT base) {
        CompoundNBT compound;
        if (NBTHelper.hasPersistentData(base)) {
            compound = base.func_74775_l("astralsorcery");
        } else {
            compound = new CompoundNBT();
            base.func_218657_a("astralsorcery", (INBT)compound);
        }
        return compound;
    }

    public static boolean hasPersistentData(Entity entity) {
        return NBTHelper.hasPersistentData(entity.getPersistentData());
    }

    public static boolean hasPersistentData(ItemStack item) {
        return item.func_77942_o() && NBTHelper.hasPersistentData(item.func_77978_p());
    }

    public static boolean hasPersistentData(CompoundNBT base) {
        return base.func_74764_b("astralsorcery") && base.func_74781_a("astralsorcery") instanceof CompoundNBT;
    }

    public static void removePersistentData(Entity entity) {
        NBTHelper.removePersistentData(entity.getPersistentData());
    }

    public static void removePersistentData(ItemStack item) {
        if (item.func_77942_o()) {
            NBTHelper.removePersistentData(item.func_77978_p());
        }
    }

    public static void removePersistentData(CompoundNBT base) {
        base.func_82580_o("astralsorcery");
    }

    public static void deepMerge(CompoundNBT dst, CompoundNBT src) {
        for (String s : src.func_150296_c()) {
            INBT nbtElement = src.func_74781_a(s);
            if (nbtElement.func_74732_a() == 10) {
                if (dst.func_150297_b(s, 10)) {
                    NBTHelper.deepMerge(dst.func_74775_l(s), (CompoundNBT)nbtElement);
                    continue;
                }
                dst.func_218657_a(s, nbtElement.func_74737_b());
                continue;
            }
            if (nbtElement.func_74732_a() == 9) {
                if (dst.func_150297_b(s, 9)) {
                    ListNBT dstList = (ListNBT)dst.func_74781_a(s);
                    ListNBT srcList = (ListNBT)nbtElement;
                    if (dstList.func_150303_d() == srcList.func_150303_d()) {
                        NBTHelper.deepMergeList(dstList, srcList);
                        continue;
                    }
                    dst.func_218657_a(s, (INBT)srcList.func_74737_b());
                    continue;
                }
                dst.func_218657_a(s, nbtElement.func_74737_b());
                continue;
            }
            dst.func_218657_a(s, nbtElement.func_74737_b());
        }
    }

    private static void deepMergeList(ListNBT dst, ListNBT src) {
        for (int j = 0; j < src.size(); ++j) {
            INBT toAdd = src.get(j);
            boolean found = false;
            for (int i = 0; i < dst.size(); ++i) {
                INBT existing = dst.get(i);
                if (!existing.equals(toAdd)) continue;
                found = true;
                break;
            }
            if (!found) continue;
            dst.add((Object)toAdd.func_74737_b());
        }
    }

    @Nonnull
    public static <E, N extends INBT> List<E> readList(CompoundNBT nbt, String key, int type, Function<N, E> deserializer) {
        if (!nbt.func_150297_b(key, 9)) {
            return new ArrayList();
        }
        return NBTHelper.readList(nbt.func_150295_c(key, type), deserializer);
    }

    @Nonnull
    public static <E, N extends INBT> List<E> readList(ListNBT nbt, Function<N, E> deserializer) {
        return nbt.stream().map(n -> deserializer.apply(n)).collect(Collectors.toList());
    }

    @Nonnull
    public static <E, N extends INBT> Set<E> readSet(CompoundNBT nbt, String key, int type, Function<N, E> deserializer) {
        if (!nbt.func_150297_b(key, 9)) {
            return new HashSet();
        }
        return NBTHelper.readSet(nbt.func_150295_c(key, type), deserializer);
    }

    @Nonnull
    public static <E, N extends INBT> Set<E> readSet(ListNBT nbt, Function<N, E> deserializer) {
        return nbt.stream().map(n -> deserializer.apply(n)).collect(Collectors.toSet());
    }

    public static <E> void writeList(CompoundNBT tag, String key, Collection<E> collection, Function<E, INBT> serializer) {
        tag.func_218657_a(key, (INBT)NBTHelper.writeList(collection, serializer));
    }

    public static <E> ListNBT writeList(Collection<E> collection, Function<E, INBT> serializer) {
        ListNBT nbt = new ListNBT();
        nbt.addAll((Collection)collection.stream().map(serializer).collect(Collectors.toList()));
        return nbt;
    }

    public static CompoundNBT getData(ItemStack stack) {
        CompoundNBT compound = stack.func_77978_p();
        if (compound == null) {
            compound = new CompoundNBT();
            stack.func_77982_d(compound);
        }
        return compound;
    }

    public static <T> void writeOptional(CompoundNBT nbt, String key, @Nullable T object, BiConsumer<CompoundNBT, T> writer) {
        nbt.func_74757_a(key + "_present", object != null);
        if (object != null) {
            CompoundNBT write = new CompoundNBT();
            writer.accept(write, (CompoundNBT)object);
            nbt.func_218657_a(key, (INBT)write);
        }
    }

    @Nullable
    public static <T> T readOptional(CompoundNBT nbt, String key, Function<CompoundNBT, T> reader) {
        return NBTHelper.readOptional(nbt, key, reader, null);
    }

    @Nullable
    public static <T> T readOptional(CompoundNBT nbt, String key, Function<CompoundNBT, T> reader, T _default) {
        if (nbt.func_74767_n(key + "_present")) {
            CompoundNBT read = nbt.func_74775_l(key);
            return reader.apply(read);
        }
        return _default;
    }

    public static <T extends Enum<T>> void writeEnum(CompoundNBT nbt, String key, T enumValue) {
        nbt.func_74768_a(key, enumValue.ordinal());
    }

    public static <T extends Enum<T>> T readEnum(CompoundNBT nbt, String key, Class<T> enumClazz) {
        if (!enumClazz.isEnum()) {
            throw new IllegalArgumentException("Passed class is not an enum!");
        }
        return (T)((Enum[])enumClazz.getEnumConstants())[nbt.func_74762_e(key)];
    }

    public static void setBlockState(CompoundNBT cmp, String key, BlockState state) {
        CompoundNBT serialized = NBTHelper.getBlockStateNBTTag(state);
        cmp.func_218657_a(key, (INBT)serialized);
    }

    @Nullable
    public static BlockState getBlockState(CompoundNBT cmp, String key) {
        return NBTHelper.getBlockStateFromTag(cmp.func_74775_l(key));
    }

    @Nonnull
    public static CompoundNBT getBlockStateNBTTag(BlockState state) {
        if (state.func_177230_c().getRegistryName() == null) {
            state = Blocks.field_150350_a.func_176223_P();
        }
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("registryName", state.func_177230_c().getRegistryName().toString());
        ListNBT properties = new ListNBT();
        for (IProperty property : state.func_206869_a()) {
            CompoundNBT propTag = new CompoundNBT();
            try {
                propTag.func_74778_a("value", property.func_177702_a(state.func_177229_b(property)));
            }
            catch (Exception exc) {
                continue;
            }
            propTag.func_74778_a("property", property.func_177701_a());
            properties.add((Object)propTag);
        }
        tag.func_218657_a("properties", (INBT)properties);
        return tag;
    }

    @Nullable
    public static BlockState getBlockStateFromTag(CompoundNBT cmp) {
        return NBTHelper.getBlockStateFromTag(cmp, null);
    }

    @Nullable
    public static <T extends Comparable<T>> BlockState getBlockStateFromTag(CompoundNBT cmp, BlockState _default) {
        ResourceLocation key = new ResourceLocation(cmp.func_74779_i("registryName"));
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(key);
        if (block == null || block == Blocks.field_150350_a) {
            return _default;
        }
        BlockState state = block.func_176223_P();
        Collection properties = state.func_206869_a();
        ListNBT list = cmp.func_150295_c("properties", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT propertyTag = list.func_150305_b(i);
            String valueStr = propertyTag.func_74779_i("value");
            String propertyStr = propertyTag.func_74779_i("property");
            IProperty match = MiscUtils.iterativeSearch(properties, prop -> prop.func_177701_a().equalsIgnoreCase(propertyStr));
            if (match == null) continue;
            try {
                Optional opt = match.func_185929_b(valueStr);
                if (!opt.isPresent()) continue;
                state = (BlockState)state.func_206870_a(match, (Comparable)opt.get());
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return state;
    }

    public static void setAsSubTag(CompoundNBT compound, String tag, Consumer<CompoundNBT> applyFct) {
        CompoundNBT newTag = new CompoundNBT();
        applyFct.accept(newTag);
        compound.func_218657_a(tag, (INBT)newTag);
    }

    @Nullable
    public static <T> T readFromSubTag(CompoundNBT compound, String tag, Function<CompoundNBT, T> readFct) {
        if (compound.func_150297_b(tag, 10)) {
            return readFct.apply(compound.func_74775_l(tag));
        }
        return null;
    }

    public static <T extends IForgeRegistryEntry<T>> void setRegistryEntry(CompoundNBT compoundNBT, String tag, T entry) {
        NBTHelper.setResourceLocation(compoundNBT, tag + "_registry", RegistryManager.ACTIVE.getRegistry(entry.getRegistryType()).getRegistryName());
        NBTHelper.setResourceLocation(compoundNBT, tag, entry.getRegistryName());
    }

    @Nullable
    public static <T extends IForgeRegistryEntry<T>> T getRegistryEntry(CompoundNBT compoundNBT, String tag) {
        ResourceLocation key;
        ForgeRegistry registry;
        ResourceLocation registryName = NBTHelper.getResourceLocation(compoundNBT, tag + "_registry");
        if (registryName != null && (registry = RegistryManager.ACTIVE.getRegistry(registryName)) != null && (key = NBTHelper.getResourceLocation(compoundNBT, tag)) != null) {
            return (T)registry.getValue(key);
        }
        return null;
    }

    public static void setResourceLocation(CompoundNBT compoundNBT, String tag, ResourceLocation key) {
        compoundNBT.func_74778_a(tag, key.toString());
    }

    @Nullable
    public static ResourceLocation getResourceLocation(CompoundNBT compoundNBT, String tag) {
        if (compoundNBT.func_74764_b(tag)) {
            return new ResourceLocation(compoundNBT.func_74779_i(tag));
        }
        return null;
    }

    public static void setStack(CompoundNBT compound, String tag, ItemStack stack) {
        NBTHelper.setAsSubTag(compound, tag, arg_0 -> ((ItemStack)stack).func_77955_b(arg_0));
    }

    public static ItemStack getStack(CompoundNBT compound, String tag) {
        return NBTHelper.readFromSubTag(compound, tag, ItemStack::func_199557_a);
    }

    public static void setFluid(CompoundNBT compound, String tag, FluidStack stack) {
        NBTHelper.setAsSubTag(compound, tag, arg_0 -> ((FluidStack)stack).writeToNBT(arg_0));
    }

    public static FluidStack getFluid(CompoundNBT compound, String tag) {
        return NBTHelper.readFromSubTag(compound, tag, FluidStack::loadFluidStackFromNBT);
    }

    public static void removeUUID(CompoundNBT compound, String key) {
        compound.func_82580_o(key + "Most");
        compound.func_82580_o(key + "Least");
    }

    public static CompoundNBT writeBlockPosToNBT(BlockPos pos, CompoundNBT compound) {
        compound.func_74768_a("bposX", pos.func_177958_n());
        compound.func_74768_a("bposY", pos.func_177956_o());
        compound.func_74768_a("bposZ", pos.func_177952_p());
        return compound;
    }

    public static BlockPos readBlockPosFromNBT(CompoundNBT compound) {
        int x = compound.func_74762_e("bposX");
        int y = compound.func_74762_e("bposY");
        int z = compound.func_74762_e("bposZ");
        return new BlockPos(x, y, z);
    }

    public static CompoundNBT writeVector3(Vector3 v) {
        CompoundNBT cmp = new CompoundNBT();
        NBTHelper.writeVector3(v, cmp);
        return cmp;
    }

    public static CompoundNBT writeVector3(Vector3 v, CompoundNBT compound) {
        compound.func_74780_a("vecPosX", v.getX());
        compound.func_74780_a("vecPosY", v.getY());
        compound.func_74780_a("vecPosZ", v.getZ());
        return compound;
    }

    public static Vector3 readVector3(CompoundNBT compound) {
        return new Vector3(compound.func_74769_h("vecPosX"), compound.func_74769_h("vecPosY"), compound.func_74769_h("vecPosZ"));
    }

    public static CompoundNBT writeBoundingBox(AxisAlignedBB box, CompoundNBT tag) {
        tag.func_74780_a("boxMinX", box.field_72340_a);
        tag.func_74780_a("boxMinY", box.field_72338_b);
        tag.func_74780_a("boxMinZ", box.field_72339_c);
        tag.func_74780_a("boxMaxX", box.field_72336_d);
        tag.func_74780_a("boxMaxY", box.field_72337_e);
        tag.func_74780_a("boxMaxZ", box.field_72334_f);
        return tag;
    }

    public static AxisAlignedBB readBoundingBox(CompoundNBT tag) {
        return new AxisAlignedBB(tag.func_74769_h("boxMinX"), tag.func_74769_h("boxMinY"), tag.func_74769_h("boxMinZ"), tag.func_74769_h("boxMaxX"), tag.func_74769_h("boxMaxY"), tag.func_74769_h("boxMaxZ"));
    }
}

