/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util.world;

import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.play.client.PktRequestSeed;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class WorldSeedCache {
    private static int activeSession = 0;
    private static Map<DimensionType, Long> cacheSeedLookup = new HashMap<DimensionType, Long>();

    @OnlyIn(value=Dist.CLIENT)
    public static void clearClient() {
        ++activeSession;
        cacheSeedLookup.clear();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void updateSeedCache(DimensionType type, int session, long seed) {
        if (activeSession == session) {
            cacheSeedLookup.put(type, seed);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Optional<Long> getSeedIfPresent(World world) {
        if (world == null) {
            return Optional.empty();
        }
        return WorldSeedCache.getSeedIfPresent(world.func_201675_m().func_186058_p());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Optional<Long> getSeedIfPresent(DimensionType type) {
        if (!cacheSeedLookup.containsKey(type)) {
            PktRequestSeed req = new PktRequestSeed(++activeSession, type);
            PacketChannel.CHANNEL.sendToServer(req);
            return Optional.empty();
        }
        return Optional.of(cacheSeedLookup.get(type));
    }
}

