/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.world.placement;

import com.mojang.datafixers.Dynamic;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.world.config.ReplacingFeaturePlacementConfig;
import java.util.ArrayList;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.Fluid;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.placement.Placement;

public class RiverbedPlacement
extends Placement<ReplacingFeaturePlacementConfig> {
    public RiverbedPlacement(Function<Dynamic<?>, ? extends ReplacingFeaturePlacementConfig> cfgSupplier) {
        super(cfgSupplier);
    }

    public RiverbedPlacement(ReplacingFeaturePlacementConfig config) {
        super(dyn -> config);
    }

    public Stream<BlockPos> getPositions(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> generatorIn, Random random, ReplacingFeaturePlacementConfig configIn, BlockPos pos) {
        if (!configIn.canGenerateAtAll() || random.nextInt(Math.max(configIn.getGenerationChance(), 1)) != 0) {
            return Stream.empty();
        }
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        for (int i = 0; i < configIn.getGenerationAmount(); ++i) {
            BlockPos at = pos.func_177982_a(random.nextInt(16), configIn.getRandomY(random), random.nextInt(16));
            if (!configIn.canPlace(worldIn, generatorIn.func_202090_b(), at, random)) continue;
            boolean foundWater = false;
            for (int yy = 0; yy < 3; ++yy) {
                BlockPos check = at.func_177967_a(Direction.UP, yy);
                BlockState bs = worldIn.func_180495_p(check);
                Block block = bs.func_177230_c();
                Fluid f = MiscUtils.tryGetFuild(bs);
                if ((f == null || !f.func_207185_a(FluidTags.field_206959_a)) && !block.func_203417_a(BlockTags.field_205213_E)) continue;
                foundWater = true;
                at = check.func_177977_b();
                break;
            }
            if (!foundWater) continue;
            result.add(at);
        }
        return result.stream();
    }
}

