/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.world.placement;

import com.mojang.datafixers.Dynamic;
import hellfirepvp.astralsorcery.common.world.config.FeaturePlacementConfig;
import hellfirepvp.astralsorcery.common.world.config.StructurePlacementConfig;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.placement.Placement;

public class StructurePlacement<DC extends StructurePlacementConfig>
extends Placement<DC> {
    public StructurePlacement(Function<Dynamic<?>, ? extends DC> cfgFactory) {
        super(cfgFactory);
    }

    public Stream<BlockPos> getPositions(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> generatorIn, Random random, DC configIn, BlockPos pos) {
        if (!((FeaturePlacementConfig)configIn).canGenerateAtAll()) {
            return Stream.empty();
        }
        BlockPos generationPos = this.getStructurePosition(generatorIn, random, ((StructurePlacementConfig)configIn).getStructureSize(), new ChunkPos(pos));
        return generationPos != null ? Stream.of(generationPos) : Stream.empty();
    }

    @Nullable
    public BlockPos getStructurePosition(ChunkGenerator<?> chunkGen, Random random, int structureSize, ChunkPos chunkPos) {
        int hxhz;
        int hxlz;
        int lxhz;
        int sizeZ;
        BlockPos pos = chunkPos.func_206849_h().func_177982_a(random.nextInt(16), 0, random.nextInt(16));
        int x = chunkPos.func_180334_c() + 8 + random.nextInt(16);
        int z = chunkPos.func_180333_d() + 8 + random.nextInt(16);
        int size = structureSize / 2;
        int sizeX = MathHelper.func_76141_d((float)((float)structureSize / 2.0f));
        int lxlz = this.getHeight(chunkGen, pos.func_177982_a(-sizeX, 0, -(sizeZ = MathHelper.func_76123_f((float)((float)structureSize / 2.0f)))), Heightmap.Type.OCEAN_FLOOR_WG);
        int y = (lxlz + (lxhz = this.getHeight(chunkGen, pos.func_177982_a(-sizeX, 0, sizeZ), Heightmap.Type.OCEAN_FLOOR_WG)) + (hxlz = this.getHeight(chunkGen, pos.func_177982_a(sizeX, 0, -sizeZ), Heightmap.Type.OCEAN_FLOOR_WG)) + (hxhz = this.getHeight(chunkGen, pos.func_177982_a(sizeX, 0, sizeZ), Heightmap.Type.OCEAN_FLOOR_WG))) / 4;
        BlockPos at = new BlockPos(x, y, z);
        return this.hasSafeFoundation(chunkGen, at, size) ? at : null;
    }

    protected boolean hasSafeFoundation(ChunkGenerator<?> chunkGen, BlockPos pos, int structSize) {
        int y = pos.func_177956_o();
        int diff = structSize / 2;
        int offsetY = this.getHeight(chunkGen, pos, Heightmap.Type.OCEAN_FLOOR_WG);
        if (Math.abs(offsetY - y) > diff) {
            return false;
        }
        offsetY = this.getHeight(chunkGen, pos.func_177982_a(structSize, 0, structSize), Heightmap.Type.OCEAN_FLOOR_WG);
        if (Math.abs(offsetY - y) > diff) {
            return false;
        }
        offsetY = this.getHeight(chunkGen, pos.func_177982_a(-structSize, 0, structSize), Heightmap.Type.OCEAN_FLOOR_WG);
        if (Math.abs(offsetY - y) > diff) {
            return false;
        }
        offsetY = this.getHeight(chunkGen, pos.func_177982_a(-structSize, 0, -structSize), Heightmap.Type.OCEAN_FLOOR_WG);
        if (Math.abs(offsetY - y) > diff) {
            return false;
        }
        offsetY = this.getHeight(chunkGen, pos.func_177982_a(structSize, 0, -structSize), Heightmap.Type.OCEAN_FLOOR_WG);
        return Math.abs(offsetY - y) <= diff;
    }

    private int getHeight(ChunkGenerator<?> chunkGen, BlockPos pos, Heightmap.Type type) {
        return chunkGen.func_222531_c(pos.func_177958_n(), pos.func_177952_p(), type);
    }
}

