/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.world.structure;

import hellfirepvp.astralsorcery.common.constellation.ConstellationRegistry;
import hellfirepvp.astralsorcery.common.constellation.IMajorConstellation;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.lib.CrystalPropertiesAS;
import hellfirepvp.astralsorcery.common.tile.TileCollectorCrystal;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import java.util.Random;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public abstract class TemplateStructure
extends TemplateStructurePiece {
    public TemplateStructure(IStructurePieceType structureType, TemplateManager mgr, BlockPos templatePosition) {
        super(structureType, 0);
        this.field_186178_c = templatePosition;
        this.loadTemplate(mgr);
    }

    public TemplateStructure(IStructurePieceType structureType, TemplateManager mgr, CompoundNBT nbt) {
        super(structureType, nbt);
        this.loadTemplate(mgr);
    }

    private void loadTemplate(TemplateManager mgr) {
        Template tpl = mgr.func_200220_a(this.getStructureName());
        PlacementSettings settings = new PlacementSettings().func_186222_a(true).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
        this.func_186173_a(tpl, this.field_186178_c, settings);
    }

    protected void generateShrineCollectorCrystal(IWorld world, BlockPos pos, Random rand) {
        world.func_180501_a(pos, BlocksAS.ROCK_COLLECTOR_CRYSTAL.func_176223_P(), 2);
        TileCollectorCrystal tcc = MiscUtils.getTileAt((IBlockReader)world, pos, TileCollectorCrystal.class, true);
        if (tcc != null) {
            IMajorConstellation cst = MiscUtils.getRandomEntry(ConstellationRegistry.getMajorConstellations(), rand);
            tcc.setAttributes(CrystalPropertiesAS.WORLDGEN_SHRINE_COLLECTOR_ATTRIBUTES);
            tcc.setAttunedConstellation(cst);
        }
    }

    public abstract ResourceLocation getStructureName();
}

