/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader.client;

import codechicken.chunkloader.client.TileChunkLoaderRenderer;
import codechicken.lib.model.bakedmodels.WrappedItemModel;
import codechicken.lib.render.CCModelLibrary;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.render.item.IItemRenderer;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.util.ClientUtils;
import codechicken.lib.util.TransformUtils;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.TransformationMatrix;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.item.ItemStack;

public class ChunkLoaderItemModel
extends WrappedItemModel
implements IItemRenderer {
    private final boolean spotLoader;

    public ChunkLoaderItemModel(IBakedModel wrappedModel, boolean spotLoader) {
        super(wrappedModel);
        this.spotLoader = spotLoader;
    }

    public void renderItem(ItemStack stack, ItemCameraTransforms.TransformType transformType, MatrixStack mStack, IRenderTypeBuffer getter, int packedLight, int packedOverlay) {
        double size;
        double height;
        this.renderWrapped(stack, transformType, mStack, getter, packedLight, packedOverlay);
        double rot = ClientUtils.getRenderTime() / 6.0;
        if (!this.spotLoader) {
            height = 0.9;
            size = 0.08;
        } else {
            height = 0.55;
            size = 0.05;
        }
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.brightness = packedLight;
        ccrs.overlay = packedOverlay;
        ccrs.reset();
        Matrix4 pearlMat = RenderUtils.getMatrix((Matrix4)new Matrix4(mStack), (Vector3)new Vector3(0.5, height, 0.5), (Rotation)new Rotation(rot, Vector3.Y_POS), (double)size);
        ccrs.brightness = 0xF000F0;
        ccrs.bind(TileChunkLoaderRenderer.pearlType, getter);
        CCModelLibrary.icosahedron4.render(ccrs, new IVertexOperation[]{pearlMat});
        ccrs.reset();
    }

    public ImmutableMap<ItemCameraTransforms.TransformType, TransformationMatrix> getTransforms() {
        return TransformUtils.DEFAULT_BLOCK;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_230044_c_() {
        return true;
    }
}

