/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.smoke;

import com.endertech.common.Args;
import com.endertech.common.IntBounds;
import com.endertech.common.KeyValuePair;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.configs.IHaveConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.data.INBTSerializable;
import com.endertech.minecraft.forge.units.ForgeEmitter;
import com.endertech.minecraft.mods.adchimneys.smoke.Smoke;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;

public class Emitter
extends ForgeEmitter
implements INBTSerializable<Emitter> {
    private final ColorARGB color;
    private final Smoke smoke;
    private final boolean canEmitAside;
    private final boolean emitWithoutChimney;
    private final int maxGapLength;

    public Emitter() {
        this(Properties.withId(""));
    }

    public Emitter(Properties<?> props) {
        this(null, props);
    }

    public Emitter(@Nullable UnitConfig config, Properties<?> props) {
        super(config, props);
        String category = this.getClassCategory();
        this.color = UnitConfig.getColorARGB((UnitConfig)config, (String)category, (String)"color", (ColorARGB)props.color, (String)"Defines a color in ARGB (Alpha, Red, Green, Blue) hex format (0xaarrggbb) which will be applied to the smoke.\nThe alpha channel of this color (aa) determines probability of applying (ff - always, 7f - 1/2, 00 - never).\n");
        this.smoke = new Smoke(config, props.smoke.getAmount(), props.smoke.getIntensity(), props.smoke.getScale(), this.color);
        this.canEmitAside = UnitConfig.getBool((UnitConfig)config, (String)category, (String)"canEmitAside", (boolean)props.canEmitAside, (String)"If true, the smoke will be transferred to the chimneys directly connected from aside.");
        this.emitWithoutChimney = UnitConfig.getBool((UnitConfig)config, (String)category, (String)"emitWithoutChimney", (boolean)props.emitWithoutChimney, (String)"If true, the smoke particles will be generated even without connected chimney.");
        this.maxGapLength = UnitConfig.getInt((UnitConfig)config, (String)category, (String)"maxGapLength", (int)props.maxGapLength, (IntBounds)IntBounds.from((Integer)0, (Integer)16), (String)"Defines the maximum allowable air gap between the emitter and the chimney located above.");
        this.saveConfig();
    }

    public ColorARGB getColor() {
        return this.color;
    }

    public Emitter readFrom(CompoundNBT compound) {
        CompoundNBT tag = compound.func_74775_l(this.getTagName());
        String id = tag.func_74779_i("related_block_id");
        Properties<?> props = Properties.withId(id);
        ((Properties)((Object)props.smoke(this.getSmoke().readFrom(tag)))).color(tag.func_74762_e("color"));
        props.maxGapLength = tag.func_74762_e("max_gap_length");
        props.canEmitAside = tag.func_74767_n("can_emit_aside");
        props.emitWithoutChimney = tag.func_74767_n("emit_without_chimney");
        props.activeTag(tag.func_74779_i("active_tag"));
        props.identityTag(KeyValuePair.from((String)tag.func_74779_i("identity_tag")));
        return new Emitter(props);
    }

    public CompoundNBT writeTo(CompoundNBT compound) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("related_block_id", this.getRelatedId().toString());
        this.getSmoke().writeTo(tag);
        tag.func_74768_a("color", this.getColor().getARGB());
        tag.func_74757_a("can_emit_aside", this.canEmitAside());
        tag.func_74757_a("emit_without_chimney", this.emitWithoutChimney());
        tag.func_74768_a("max_gap_length", this.getMaxGapLength());
        tag.func_74778_a("active_tag", this.getActiveTag());
        tag.func_74778_a("identity_tag", this.getIdentityTag().toString());
        compound.func_218657_a(this.getTagName(), (INBT)tag);
        return compound;
    }

    public Smoke getSmoke(IWorldReader world, BlockPos pos, boolean useTopEmitter, boolean useSideEmitter) {
        if ((useTopEmitter || useSideEmitter && this.canEmitAside()) && this.isActive(world, pos)) {
            return new Smoke().combine(this.getSmoke());
        }
        return new Smoke();
    }

    public String toString() {
        return Emitter.class.getSimpleName() + Args.group((Object[])new Object[]{Args.get((String)"canEmitAside", (Object)this.canEmitAside()), Args.get((String)"activeStateTag", (Object)this.getActiveTag()), this.getSmoke()}) + Args.extend((Object)super.toString());
    }

    public int getMaxGapLength() {
        return this.maxGapLength;
    }

    public boolean canEmitAside() {
        return this.canEmitAside;
    }

    public Smoke getSmoke() {
        return this.smoke;
    }

    public boolean emitWithoutChimney() {
        return this.emitWithoutChimney;
    }

    public boolean isEntity() {
        return false;
    }

    public String getClassCategory() {
        return IHaveConfig.getClassCategory(Emitter.class);
    }

    public static class Properties<T extends Properties<T>>
    extends ForgeEmitter.Properties<T> {
        public ColorARGB color = Smoke.getDefaultColor();
        public Smoke smoke = Smoke.getNone();
        public boolean canEmitAside = true;
        public boolean emitWithoutChimney = true;
        public int maxGapLength = 0;

        protected Properties(Class<T> selfClazz) {
            super(selfClazz);
        }

        public static Properties<?> withActiveState() {
            return Properties.withEnumId("[active=true]");
        }

        public static Properties<?> withLitState() {
            return Properties.withEnumId("[lit=true]");
        }

        public static Properties<?> withEnumId() {
            return Properties.withEnumId("*");
        }

        public static Properties<?> withEnumId(String metadata) {
            Properties<Properties> props = new Properties<Properties>(Properties.class);
            return (Properties)props.enumId(metadata);
        }

        public static Properties<?> withId(String id) {
            Properties<Properties> props = new Properties<Properties>(Properties.class);
            return (Properties)props.id(id);
        }

        public T activeState(String property) {
            this.id = this.id.withMetaData("[" + property + "=true]");
            return (T)((Object)((Properties)this.self));
        }

        public T color(int argb) {
            return this.color(ColorARGB.from((int)argb));
        }

        public T color(ColorARGB color) {
            this.color = color;
            return (T)((Object)((Properties)this.self));
        }

        public T smoke(int amount, float intensity) {
            return this.smoke(amount, intensity, 2.0f);
        }

        public T smoke(int amount, float intensity, float scale) {
            return this.smoke(new Smoke(amount, intensity, scale));
        }

        public T smoke(Smoke smoke) {
            this.smoke = smoke;
            return (T)((Object)((Properties)this.self));
        }

        public T notEmitAside() {
            this.canEmitAside = false;
            return (T)((Object)((Properties)this.self));
        }

        public T notEmitWithoutChimney() {
            this.emitWithoutChimney = false;
            return (T)((Object)((Properties)this.self));
        }

        public T maxGapLength(int length) {
            this.maxGapLength = length;
            return (T)((Object)((Properties)this.self));
        }
    }
}

